/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.base;

import com.hazelcast.impl.base.CallState;
import com.hazelcast.impl.base.RemoteCallKey;
import com.hazelcast.nio.Address;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CallStateService {
    private final ConcurrentMap<Long, CallState> mapLocalCallStates = new ConcurrentHashMap<Long, CallState>(100);
    private final ConcurrentMap<RemoteCallKey, CallState> mapRemoteCallStates = new ConcurrentHashMap<RemoteCallKey, CallState>(100);

    public CallState newRemoteCallState(long callId, Address remoteCallerAddress, int callerThreadId) {
        RemoteCallKey remoteCallKey = new RemoteCallKey(remoteCallerAddress, callerThreadId);
        CallState callStateNew = new CallState(callId, remoteCallerAddress, callerThreadId);
        CallState callBefore = this.mapRemoteCallStates.put(remoteCallKey, callStateNew);
        return callStateNew;
    }

    public CallState getRemoteCallState(Address remoteCallerAddress, int callerThreadId) {
        RemoteCallKey remoteCallKey = new RemoteCallKey(remoteCallerAddress, callerThreadId);
        return (CallState)this.mapRemoteCallStates.get(remoteCallKey);
    }

    public CallState newLocalCallState(long callId, Address thisAddress, int callerThreadId) {
        CallState callStateNew = new CallState(callId, thisAddress, callerThreadId);
        CallState callBefore = this.mapLocalCallStates.put(callId, callStateNew);
        return callStateNew;
    }

    public CallState getLocalCallState(long callId) {
        return (CallState)this.mapLocalCallStates.get(callId);
    }

    public CallState getLocalCallStateByThreadId(int callerThreadId) {
        for (CallState callState : this.mapLocalCallStates.values()) {
            if (callerThreadId != callState.getCallerThreadId()) continue;
            return callState;
        }
        return null;
    }

    public void shutdown() {
        this.mapLocalCallStates.clear();
        this.mapRemoteCallStates.clear();
    }
}

