/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.IOService;
import java.util.logging.Level;

class ConnectionMonitor {
    final ILogger logger;
    final ConnectionManager connectionManager;
    final IOService ioService;
    final Address endPoint;
    final long minInterval;
    final int maxFaults;
    int faults = 0;
    long lastFaultTime = 0L;

    public ConnectionMonitor(ConnectionManager connectionManager, Address endPoint) {
        this.connectionManager = connectionManager;
        this.endPoint = endPoint;
        this.ioService = connectionManager.getIOHandler();
        this.minInterval = this.ioService.getConnectionMonitorInterval();
        this.maxFaults = this.ioService.getConnectionMonitorMaxFaults();
        this.logger = this.ioService.getLogger(this.getClass().getName());
    }

    public Address getEndPoint() {
        return this.endPoint;
    }

    public synchronized void onError(Throwable t) {
        this.logger.log(Level.FINEST, "An error occured on connection to " + this.endPoint + this.getCauseDescription(t));
        long now = System.currentTimeMillis();
        long last = this.lastFaultTime;
        if (now - last > this.minInterval) {
            if (++this.faults >= this.maxFaults) {
                this.logger.log(Level.WARNING, "Removing connection to endpoint " + this.endPoint + this.getCauseDescription(t));
                this.ioService.removeEndpoint(this.endPoint);
            }
            this.lastFaultTime = now;
        }
    }

    public synchronized void reset() {
        this.logger.log(Level.FINEST, "Resetting connection monitor for endpoint " + this.endPoint);
        this.faults = 0;
        this.lastFaultTime = 0L;
    }

    private String getCauseDescription(Throwable t) {
        StringBuilder s = new StringBuilder(" Cause => ");
        if (t != null) {
            s.append(t.getClass().getName()).append(" {").append(t.getMessage()).append("}");
        } else {
            s.append("Unknown");
        }
        return s.append(", Error-Count: ").append(this.faults).toString();
    }
}

