/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.CustomSerializer;
import com.hazelcast.nio.CustomSerializerAdapter;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.FastByteArrayInputStream;
import com.hazelcast.nio.FastByteArrayOutputStream;
import com.hazelcast.nio.HazelcastSerializationException;
import com.hazelcast.nio.Serializer;
import com.hazelcast.nio.TypeSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Constructor;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSerializer {
    private static final ILogger logger = Logger.getLogger(AbstractSerializer.class.getName());
    private static final int OUTPUT_STREAM_BUFFER_SIZE = 102400;
    private static final Class[] PRIMITIVE_CLASSES_ARRAY = new Class[]{Integer.TYPE, Long.TYPE, Boolean.TYPE, Byte.TYPE, Float.TYPE, Double.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Void.TYPE};
    private static final int MAX_PRIM_CLASSNAME_LENGTH = 7;
    private final FastByteArrayOutputStream bbos;
    private final FastByteArrayInputStream bbis;
    private final Serializer.DataSerializer ds;
    private final CustomSerializerAdapter cs;

    public AbstractSerializer(Serializer.DataSerializer ds, CustomSerializer cs) {
        this.ds = ds;
        this.cs = new CustomSerializerAdapter(cs);
        this.bbis = new FastByteArrayInputStream(new byte[10]);
        this.bbos = new FastByteArrayOutputStream(102400);
    }

    public static Object newInstance(Class klass) throws Exception {
        Constructor constructor = klass.getDeclaredConstructor(new Class[0]);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        return constructor.newInstance(new Object[0]);
    }

    public static Class<?> loadClass(String className) throws ClassNotFoundException {
        return AbstractSerializer.loadClass(null, className);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        if (className == null) {
            throw new IllegalArgumentException("ClassName cannot be null!");
        }
        if (className.length() <= 7 && Character.isLowerCase(className.charAt(0))) {
            for (int i = 0; i < PRIMITIVE_CLASSES_ARRAY.length; ++i) {
                if (!className.equals(PRIMITIVE_CLASSES_ARRAY[i].getName())) continue;
                return PRIMITIVE_CLASSES_ARRAY[i];
            }
        }
        ClassLoader theClassLoader = classLoader;
        if (className.startsWith("com.hazelcast.") || className.startsWith("[Lcom.hazelcast.")) {
            theClassLoader = AbstractSerializer.class.getClassLoader();
        }
        if (theClassLoader == null) {
            theClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (theClassLoader != null) {
            if (className.startsWith("[")) {
                return Class.forName(className, true, theClassLoader);
            }
            return theClassLoader.loadClass(className);
        }
        return Class.forName(className);
    }

    public static ObjectInputStream newObjectInputStream(InputStream in) throws IOException {
        return new ObjectInputStream(in){

            @Override
            protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
                return AbstractSerializer.loadClass(desc.getName());
            }
        };
    }

    protected void toByte(FastByteArrayOutputStream bos, Object object) {
        if (object == null) {
            return;
        }
        try {
            TypeSerializer<DataSerializable> ts = this.ds.isSuitable(object) ? this.ds : this.cs;
            bos.writeByte(ts.getTypeId());
            ts.write(bos, (DataSerializable)object);
            bos.flush();
        }
        catch (Throwable e) {
            throw new HazelcastSerializationException(e);
        }
    }

    protected Object toObject(FastByteArrayInputStream bis) {
        byte typeId = -1;
        try {
            typeId = bis.readByte();
            TypeSerializer<DataSerializable> ts = typeId == this.ds.getTypeId() ? this.ds : this.cs;
            return ts.read(bis);
        }
        catch (Throwable e) {
            throw new HazelcastSerializationException("Problem when serializing type " + typeId, e);
        }
    }

    public byte[] toByteArray(Object obj) {
        if (obj == null) {
            return null;
        }
        try {
            this.bbos.reset();
            this.toByte(this.bbos, obj);
            byte[] result = this.bbos.toByteArray();
            if (this.bbos.size() > 102400) {
                this.bbos.set(new byte[102400]);
            }
            return result;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            throw new RuntimeException(e);
        }
    }

    public Object toObject(byte[] byteArray) {
        if (byteArray == null || byteArray.length == 0) {
            return null;
        }
        this.bbis.set(byteArray, byteArray.length);
        Object obj = this.toObject(this.bbis);
        this.bbis.set(null, 0);
        return obj;
    }
}

