/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.core.AtomicNumber;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.IMap;
import com.hazelcast.impl.ThreadContext;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Data;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;

public class WebFilter
implements Filter {
    private static final ILogger logger = Logger.getLogger(WebFilter.class.getName());
    private static final String HAZELCAST_REQUEST = "*hazelcast-request";
    private static final String HAZELCAST_SESSION_COOKIE_NAME = "hazelcast.sessionId";
    private static final ConcurrentMap<String, String> mapOriginalSessions = new ConcurrentHashMap<String, String>(1000);
    private static final ConcurrentMap<String, HazelcastHttpSession> mapSessions = new ConcurrentHashMap<String, HazelcastHttpSession>(1000);
    private ServletContext servletContext = null;
    private String clusterMapName = "none";
    private boolean stickySession = true;
    private boolean debug = false;

    public void init(FilterConfig config) throws ServletException {
        String debugParam = config.getInitParameter("debug");
        if (debugParam != null) {
            this.debug = Boolean.valueOf(debugParam);
        }
        this.servletContext = config.getServletContext();
        String mapName = config.getInitParameter("map-name");
        this.clusterMapName = mapName != null ? mapName : "_web_" + this.servletContext.getServletContextName();
        String stickySessionParam = config.getInitParameter("sticky-session");
        if (stickySessionParam != null) {
            this.stickySession = Boolean.valueOf(stickySessionParam);
        }
        if (!this.stickySession) {
            this.getClusterMap().addEntryListener(new EntryListener(){

                public void entryAdded(EntryEvent entryEvent) {
                }

                public void entryRemoved(EntryEvent entryEvent) {
                    if (!entryEvent.getMember().localMember()) {
                        WebFilter.this.removeSessionLocally((String)entryEvent.getKey());
                    }
                }

                public void entryUpdated(EntryEvent entryEvent) {
                    if (!entryEvent.getMember().localMember()) {
                        WebFilter.this.markSessionDirty((String)entryEvent.getKey());
                    }
                }

                public void entryEvicted(EntryEvent entryEvent) {
                }
            }, false);
        }
        this.log("sticky:" + this.stickySession + ", debug: " + this.debug + ", map-name: " + this.clusterMapName);
    }

    void removeSessionLocally(String sessionId) {
        HazelcastHttpSession hazelSession = (HazelcastHttpSession)mapSessions.remove(sessionId);
        if (hazelSession != null) {
            mapOriginalSessions.remove(hazelSession.originalSession.getId());
            this.log("Destroying session locally " + hazelSession);
            hazelSession.destroy();
        }
    }

    void markSessionDirty(String sessionId) {
        HazelcastHttpSession hazelSession = (HazelcastHttpSession)mapSessions.get(sessionId);
        if (hazelSession != null) {
            hazelSession.setDirty(true);
        }
    }

    public static void destroyOriginalSession(HttpSession originalSession) {
        HazelcastHttpSession hazelSession;
        String hazelcastSessionId = (String)mapOriginalSessions.remove(originalSession.getId());
        if (hazelcastSessionId != null && (hazelSession = (HazelcastHttpSession)mapSessions.remove(hazelcastSessionId)) != null) {
            hazelSession.webFilter.destroySession(hazelSession);
        }
    }

    void log(Object obj) {
        Level level = Level.FINEST;
        if (this.debug) {
            level = Level.INFO;
        }
        logger.log(level, obj.toString());
    }

    HazelcastHttpSession createNewSession(RequestWrapper requestWrapper, String existingSessionId) {
        String id;
        String string = id = existingSessionId != null ? existingSessionId : WebFilter.generateSessionId();
        if (requestWrapper.getOriginalSession(false) != null) {
            this.log("Original session exists!!!");
        }
        HttpSession originalSession = requestWrapper.getOriginalSession(true);
        HazelcastHttpSession hazelcastSession = new HazelcastHttpSession(this, id, originalSession);
        mapSessions.put(hazelcastSession.getId(), hazelcastSession);
        String oldHazelcastSessionId = mapOriginalSessions.put(originalSession.getId(), hazelcastSession.getId());
        if (oldHazelcastSessionId != null) {
            this.log("!!! Overriding an existing hazelcastSessionId " + oldHazelcastSessionId);
        }
        this.log("Created new session with id: " + id);
        this.log(mapSessions.size() + " is sessions.size and originalSessions.size: " + mapOriginalSessions.size());
        WebFilter.addSessionCookie(requestWrapper, id);
        return hazelcastSession;
    }

    void destroySession(HazelcastHttpSession session) {
        this.log("Destroying local session: " + session.getId());
        mapSessions.remove(session.getId());
        mapOriginalSessions.remove(session.originalSession.getId());
        session.destroy();
        long maxInactive = session.originalSession.getMaxInactiveInterval() * 1000;
        long clusterLastAccess = session.timestamp.get();
        long now = System.currentTimeMillis();
        if (now - clusterLastAccess >= maxInactive) {
            this.log("Destroying cluster session: " + session.getId() + " => Max-inactive: " + maxInactive + ", Local-Last-Access: " + session.originalSession.getLastAccessedTime() + ", Cluster-Last-Access: " + clusterLastAccess + ", Now: " + now);
            this.getClusterMap().remove(session.getId());
            session.timestamp.destroy();
        }
    }

    public IMap getClusterMap() {
        return Hazelcast.getMap(this.clusterMapName);
    }

    HazelcastHttpSession getSessionWithId(String sessionId) {
        HazelcastHttpSession session = (HazelcastHttpSession)mapSessions.get(sessionId);
        if (session != null && !session.isValid()) {
            session = null;
            this.destroySession(session);
        }
        return session;
    }

    private static synchronized String generateSessionId() {
        char[] chars;
        String id = UUID.randomUUID().toString();
        StringBuilder sb = new StringBuilder();
        for (char c : chars = id.toCharArray()) {
            if (c == '-') continue;
            if (Character.isLetter(c)) {
                sb.append(Character.toUpperCase(c));
                continue;
            }
            sb.append(c);
        }
        id = "HZ" + sb.toString();
        return id;
    }

    private static void addSessionCookie(RequestWrapper req, String sessionId) {
        Cookie sessionCookie = new Cookie(HAZELCAST_SESSION_COOKIE_NAME, sessionId);
        String path = req.getContextPath();
        if ("".equals(path)) {
            path = "/";
        }
        sessionCookie.setPath(path);
        sessionCookie.setMaxAge(-1);
        req.res.addCookie(sessionCookie);
    }

    private static String getSessionCookie(RequestWrapper req) {
        Cookie[] cookies = req.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String name = cookie.getName();
                String value = cookie.getValue();
                if (!name.equalsIgnoreCase(HAZELCAST_SESSION_COOKIE_NAME)) continue;
                return value;
            }
        }
        return null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) {
            chain.doFilter(req, res);
        } else {
            if (req instanceof RequestWrapper) {
                this.log("Request is instance of RequestWrapper! Continue...");
                chain.doFilter(req, res);
                return;
            }
            HttpServletRequest httpReq = (HttpServletRequest)req;
            RequestWrapper existingReq = (RequestWrapper)((Object)req.getAttribute(HAZELCAST_REQUEST));
            ResponseWrapper resWrapper = new ResponseWrapper((HttpServletResponse)res);
            RequestWrapper reqWrapper = new RequestWrapper(httpReq, resWrapper);
            resWrapper.setRequest(reqWrapper);
            if (existingReq != null) {
                reqWrapper.setHazelcastSession(existingReq.hazelcastSession, existingReq.requestedSessionId);
            }
            req = null;
            res = null;
            httpReq = null;
            chain.doFilter((ServletRequest)reqWrapper, (ServletResponse)resWrapper);
            if (existingReq != null) {
                return;
            }
            req = null;
            HazelcastHttpSession session = reqWrapper.getSession(false);
            if (session != null && session.isValid()) {
                session.setAccessed();
                Enumeration attNames = session.getAttributeNames();
                HashMap<String, Object> mapData = null;
                while (attNames.hasMoreElements()) {
                    String attName = (String)attNames.nextElement();
                    Object value = session.getAttribute(attName);
                    if (mapData == null) {
                        mapData = new HashMap<String, Object>();
                    }
                    mapData.put(attName, value);
                }
                Data data = session.writeObject(mapData);
                boolean sessionChanged = session.sessionChanged(data);
                if (sessionChanged) {
                    if (data == null) {
                        mapData = new HashMap();
                        data = session.writeObject(mapData);
                    }
                    this.log("PUTTING SESSION " + session.getId());
                    this.getClusterMap().put(session.getId(), data);
                }
            }
        }
    }

    public void destroy() {
        mapSessions.clear();
        mapOriginalSessions.clear();
        Hazelcast.getLifecycleService().shutdown();
    }

    private class HazelcastHttpSession
    implements HttpSession {
        private Data currentSessionData = null;
        volatile boolean valid = true;
        volatile boolean dirty = false;
        final String id;
        final HttpSession originalSession;
        final WebFilter webFilter;
        final AtomicNumber timestamp;

        public HazelcastHttpSession(WebFilter webFilter2, String sessionId, HttpSession originalSession) {
            this.webFilter = webFilter2;
            this.id = sessionId;
            this.originalSession = originalSession;
            this.timestamp = Hazelcast.getAtomicNumber(WebFilter.this.clusterMapName + "_" + this.id);
        }

        public Object getAttribute(String name) {
            return this.originalSession.getAttribute(name);
        }

        public Enumeration getAttributeNames() {
            return this.originalSession.getAttributeNames();
        }

        public String getId() {
            return this.id;
        }

        public ServletContext getServletContext() {
            return WebFilter.this.servletContext;
        }

        public HttpSessionContext getSessionContext() {
            return this.originalSession.getSessionContext();
        }

        public Object getValue(String name) {
            return this.getAttribute(name);
        }

        public String[] getValueNames() {
            return this.originalSession.getValueNames();
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public void invalidate() {
            this.originalSession.invalidate();
            WebFilter.this.destroySession(this);
        }

        public boolean isNew() {
            return this.originalSession.isNew();
        }

        public void putValue(String name, Object value) {
            this.setAttribute(name, value);
        }

        public void removeAttribute(String name) {
            this.originalSession.removeAttribute(name);
        }

        public void setAttribute(String name, Object value) {
            if (value != null && !(value instanceof Serializable)) {
                throw new IllegalArgumentException(new NotSerializableException(value.getClass().getName()));
            }
            this.originalSession.setAttribute(name, value);
        }

        public void removeValue(String name) {
            this.removeAttribute(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean sessionChanged(Data data) {
            try {
                if (data == null) {
                    boolean bl = this.currentSessionData != null;
                    return bl;
                }
                if (this.currentSessionData == null) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = !data.equals(this.currentSessionData);
                return bl;
            }
            finally {
                this.currentSessionData = data;
            }
        }

        public long getCreationTime() {
            return this.originalSession.getCreationTime();
        }

        public long getLastAccessedTime() {
            return this.originalSession.getLastAccessedTime();
        }

        public int getMaxInactiveInterval() {
            return this.originalSession.getMaxInactiveInterval();
        }

        public void setMaxInactiveInterval(int maxInactiveSeconds) {
            this.originalSession.setMaxInactiveInterval(maxInactiveSeconds);
        }

        public synchronized Data writeObject(Object obj) {
            if (obj == null) {
                return null;
            }
            return ThreadContext.get().toData(obj);
        }

        void destroy() {
            this.valid = false;
        }

        public boolean isValid() {
            return this.valid;
        }

        void setAccessed() {
            this.timestamp.set(System.currentTimeMillis());
        }
    }

    class ResponseWrapper
    extends HttpServletResponseWrapper {
        RequestWrapper req;

        public ResponseWrapper(HttpServletResponse original) {
            super(original);
            this.req = null;
        }

        public void setRequest(RequestWrapper req) {
            this.req = req;
        }
    }

    class RequestWrapper
    extends HttpServletRequestWrapper {
        HazelcastHttpSession hazelcastSession;
        final ResponseWrapper res;
        String requestedSessionId;

        public RequestWrapper(HttpServletRequest req, ResponseWrapper res) {
            super(req);
            this.hazelcastSession = null;
            this.res = res;
            req.setAttribute(WebFilter.HAZELCAST_REQUEST, (Object)this);
        }

        public void setHazelcastSession(HazelcastHttpSession hazelcastSession, String requestedSessionId) {
            this.hazelcastSession = hazelcastSession;
            this.requestedSessionId = requestedSessionId;
        }

        HttpSession getOriginalSession(boolean create) {
            return super.getSession(create);
        }

        public RequestDispatcher getRequestDispatcher(final String path) {
            final ServletRequest original = this.getRequest();
            return new RequestDispatcher(){

                public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    original.getRequestDispatcher(path).forward((ServletRequest)RequestWrapper.this, servletResponse);
                }

                public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
                    original.getRequestDispatcher(path).include((ServletRequest)RequestWrapper.this, servletResponse);
                }
            };
        }

        public String fetchHazelcastSessionId() {
            if (this.requestedSessionId != null) {
                return this.requestedSessionId;
            }
            this.requestedSessionId = WebFilter.getSessionCookie(this);
            return this.requestedSessionId;
        }

        public HttpSession getSession() {
            return this.getSession(true);
        }

        public HazelcastHttpSession getSession(boolean create) {
            Map mapSession;
            HttpSession originalSession;
            if (this.hazelcastSession != null && !this.hazelcastSession.isValid()) {
                WebFilter.this.log("Session is invalid!");
                WebFilter.this.destroySession(this.hazelcastSession);
                this.hazelcastSession = null;
            }
            if (this.hazelcastSession == null && (originalSession = this.getOriginalSession(false)) != null) {
                String hazelcastSessionId = (String)mapOriginalSessions.get(originalSession.getId());
                if (hazelcastSessionId != null) {
                    this.hazelcastSession = (HazelcastHttpSession)mapSessions.get(hazelcastSessionId);
                }
                if (this.hazelcastSession == null) {
                    mapOriginalSessions.remove(originalSession.getId());
                    originalSession.invalidate();
                } else if (this.hazelcastSession.isDirty()) {
                    this.hazelcastSession = null;
                }
            }
            if (this.hazelcastSession != null) {
                return this.hazelcastSession;
            }
            String requestedSessionId = this.fetchHazelcastSessionId();
            if (requestedSessionId != null) {
                this.hazelcastSession = WebFilter.this.getSessionWithId(requestedSessionId);
                if (this.hazelcastSession == null && (mapSession = (Map)WebFilter.this.getClusterMap().get(requestedSessionId)) != null) {
                    this.hazelcastSession = WebFilter.this.createNewSession(this, requestedSessionId);
                    this.overrideSession(this.hazelcastSession, mapSession);
                }
            }
            if (this.hazelcastSession == null && create) {
                this.hazelcastSession = WebFilter.this.createNewSession(this, null);
            } else if (this.hazelcastSession != null && !WebFilter.this.stickySession && requestedSessionId != null && this.hazelcastSession.isDirty()) {
                WebFilter.this.log(requestedSessionId + " is dirty reloading.");
                mapSession = (Map)WebFilter.this.getClusterMap().get(requestedSessionId);
                this.overrideSession(this.hazelcastSession, mapSession);
            }
            return this.hazelcastSession;
        }

        private void overrideSession(HazelcastHttpSession session, Map mapSession) {
            if (session == null || mapSession == null) {
                return;
            }
            Enumeration atts = session.getAttributeNames();
            while (atts.hasMoreElements()) {
                session.removeAttribute((String)atts.nextElement());
            }
            HashMap mapData = null;
            Set entries = mapSession.entrySet();
            for (Map.Entry entry : entries) {
                session.setAttribute((String)entry.getKey(), entry.getValue());
                if (mapData == null) {
                    mapData = new HashMap();
                }
                mapData.put(entry.getKey(), entry.getValue());
            }
            session.sessionChanged(session.writeObject(mapData));
            session.setDirty(false);
        }
    }
}

