/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl;

import com.hazelcast.impl.AbstractSimpleRecord;
import com.hazelcast.impl.CMap;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.VersionedBackupOp;
import com.hazelcast.impl.base.DistributedLock;
import com.hazelcast.impl.base.ScheduledAction;
import com.hazelcast.impl.concurrentmap.ValueHolder;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Data;
import com.hazelcast.nio.IOUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRecord
extends AbstractSimpleRecord
implements Record {
    protected volatile int hits = 0;
    protected volatile long version = 0L;
    protected volatile long maxIdleMillis = Long.MAX_VALUE;
    protected volatile long writeTime = -1L;
    protected volatile long removeTime = 0L;
    protected volatile long lastAccessTime = 0L;
    protected volatile long lastStoredTime = 0L;
    protected volatile long creationTime = 0L;
    protected volatile long expirationTime = Long.MAX_VALUE;
    protected volatile long lastUpdateTime = 0L;
    protected volatile boolean dirty = false;
    protected volatile DistributedLock lock = null;
    protected volatile OptionalInfo optionalInfo = null;

    public AbstractRecord(CMap cmap, int blockId, Data key, long ttl, long maxIdleMillis, long id) {
        super(blockId, cmap, id, key);
        this.setCreationTime(System.currentTimeMillis());
        this.setTTL(ttl);
        this.maxIdleMillis = maxIdleMillis == 0L ? Long.MAX_VALUE : maxIdleMillis;
        this.setVersion(0L);
    }

    @Override
    public void runBackupOps() {
        if (this.getBackupOps() != null && this.getBackupOps().size() > 0) {
            Iterator it = this.getBackupOps().iterator();
            while (it.hasNext()) {
                VersionedBackupOp bo = (VersionedBackupOp)it.next();
                if (bo.getVersion() < this.getVersion() + 1L) {
                    it.remove();
                    continue;
                }
                if (bo.getVersion() == this.getVersion() + 1L) {
                    bo.run();
                    this.setVersion(bo.getVersion());
                    it.remove();
                    continue;
                }
                return;
            }
        }
    }

    @Override
    public void addBackupOp(VersionedBackupOp bo) {
        if (this.getBackupOps() == null) {
            this.setBackupOps(new TreeSet<VersionedBackupOp>());
        }
        this.getBackupOps().add(bo);
        if (this.getBackupOps().size() > 4) {
            this.forceBackupOps();
        }
    }

    @Override
    public void forceBackupOps() {
        if (this.getBackupOps() == null) {
            return;
        }
        Iterator it = this.getBackupOps().iterator();
        while (it.hasNext()) {
            VersionedBackupOp v = (VersionedBackupOp)it.next();
            v.run();
            this.setVersion(v.getVersion());
            it.remove();
        }
    }

    @Override
    public Object getKey() {
        return IOUtil.toObject(this.key);
    }

    @Override
    public Long[] getIndexes() {
        if (this.optionalInfo == null) {
            return null;
        }
        return this.getOptionalInfo().indexes;
    }

    @Override
    public byte[] getIndexTypes() {
        if (this.optionalInfo == null) {
            return null;
        }
        return this.getOptionalInfo().indexTypes;
    }

    @Override
    public void setIndexes(Long[] indexes, byte[] indexTypes) {
        if (indexes != null) {
            this.getOptionalInfo().indexes = indexes;
            this.getOptionalInfo().indexTypes = indexTypes;
        }
    }

    @Override
    public boolean containsValue(Data value) {
        int count;
        if (this.hasValueData()) {
            return this.getValueData().equals(value);
        }
        if (this.getMultiValues() != null && (count = this.getMultiValues().size()) > 0) {
            return this.getMultiValues().contains(value);
        }
        return false;
    }

    @Override
    public boolean unlock(int threadId, Address address) {
        this.invalidateValueCache();
        return this.lock == null || this.lock.unlock(address, threadId);
    }

    @Override
    public boolean testLock(int threadId, Address address) {
        return this.lock == null || this.lock.testLock(threadId, address);
    }

    @Override
    public boolean lock(int threadId, Address address) {
        this.invalidateValueCache();
        if (this.lock == null) {
            this.lock = new DistributedLock(address, threadId);
            return true;
        }
        return this.lock.lock(address, threadId);
    }

    protected void invalidateValueCache() {
    }

    @Override
    public void addScheduledAction(ScheduledAction scheduledAction) {
        if (this.getScheduledActions() == null) {
            this.setScheduledActions(new LinkedList<ScheduledAction>());
        }
        this.getScheduledActions().add(scheduledAction);
    }

    @Override
    public boolean isRemovable() {
        return !this.isActive() && this.valueCount() <= 0 && this.getLockCount() <= 0 && !this.hasListener() && this.getScheduledActionCount() == 0 && this.getBackupOpCount() == 0;
    }

    @Override
    public boolean isEvictable() {
        return this.getLockCount() <= 0 && !this.hasListener() && this.getScheduledActionCount() == 0;
    }

    @Override
    public boolean hasListener() {
        return this.getListeners() != null && this.getListeners().size() > 0;
    }

    @Override
    public void addListener(Address address, boolean returnValue) {
        if (this.getListeners() == null) {
            this.setMapListeners(new ConcurrentHashMap<Address, Boolean>(1));
        }
        this.getListeners().put(address, returnValue);
    }

    @Override
    public void removeListener(Address address) {
        if (this.getListeners() == null) {
            return;
        }
        this.getListeners().remove(address);
    }

    @Override
    public void setLastUpdated() {
        if (this.expirationTime != Long.MAX_VALUE && this.expirationTime > 0L) {
            long ttl = this.expirationTime - (this.lastUpdateTime > 0L ? this.lastUpdateTime : this.creationTime);
            this.setTTL(ttl);
        }
        this.setLastUpdateTime(System.currentTimeMillis());
    }

    @Override
    public void setLastAccessed() {
        this.setLastAccessTime(System.currentTimeMillis());
        this.incrementHits();
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public long getRemainingTTL() {
        if (this.expirationTime == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long ttl = this.expirationTime - System.currentTimeMillis();
        return ttl < 0L ? 1L : ttl;
    }

    @Override
    public long getRemainingIdle() {
        if (this.maxIdleMillis == Long.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        long lastTouch = Math.max(this.lastAccessTime, this.creationTime);
        long idle = System.currentTimeMillis() - lastTouch;
        return this.maxIdleMillis - idle;
    }

    @Override
    public void setMaxIdle(long idle) {
        this.maxIdleMillis = idle <= 0L || idle == Long.MAX_VALUE ? Long.MAX_VALUE : idle;
    }

    @Override
    public void setExpirationTime(long expTime) {
        this.expirationTime = expTime <= 0L ? Long.MAX_VALUE : expTime;
    }

    @Override
    public void setTTL(long ttl) {
        if (ttl <= 0L || ttl == Long.MAX_VALUE) {
            this.setExpirationTime(Long.MAX_VALUE);
        } else {
            this.setExpirationTime(System.currentTimeMillis() + ttl);
        }
    }

    @Override
    public void setInvalid() {
        this.expirationTime = System.currentTimeMillis() - 10L;
    }

    @Override
    public boolean isValid(long now) {
        if (this.expirationTime == Long.MAX_VALUE && this.maxIdleMillis == Long.MAX_VALUE) {
            return true;
        }
        long lastTouch = Math.max(this.lastAccessTime, this.creationTime);
        long idle = now - lastTouch;
        return this.expirationTime > now && this.maxIdleMillis > idle;
    }

    @Override
    public boolean isValid() {
        return this.active && this.isValid(System.currentTimeMillis());
    }

    @Override
    public void markRemoved() {
        this.setActive(false);
        this.setRemoveTime(System.currentTimeMillis());
    }

    @Override
    public void setActive() {
        this.setRemoveTime(0L);
        this.setActive(true);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRecord)) {
            return false;
        }
        Record record = (Record)o;
        return record.getId() == this.getId();
    }

    @Override
    public String toString() {
        return "Record key=" + this.getKeyData() + ", active=" + this.isActive() + ", version=" + this.getVersion() + ", removable=" + this.isRemovable();
    }

    @Override
    public long getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(long version) {
        this.version = version;
    }

    @Override
    public void incrementVersion() {
        ++this.version;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public void setCreationTime(long newValue) {
        this.creationTime = newValue;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public void setLastAccessTime(long lastAccessTime) {
        this.lastAccessTime = lastAccessTime;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Override
    public void setLastUpdateTime(long lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Override
    public int getHits() {
        return this.hits;
    }

    @Override
    public void incrementHits() {
        ++this.hits;
    }

    @Override
    public void setActive(boolean active) {
        this.active = active;
        this.invalidateValueCache();
    }

    @Override
    public DistributedLock getLock() {
        return this.lock;
    }

    @Override
    public void setLock(DistributedLock lock) {
        this.lock = lock;
    }

    @Override
    public Collection<ValueHolder> getMultiValues() {
        if (this.optionalInfo == null) {
            return null;
        }
        return this.getOptionalInfo().lsMultiValues;
    }

    @Override
    public void setMultiValues(Collection<ValueHolder> lsValues) {
        if (lsValues != null || this.optionalInfo != null) {
            this.getOptionalInfo().lsMultiValues = lsValues;
        }
    }

    @Override
    public int getBackupOpCount() {
        if (this.optionalInfo == null) {
            return 0;
        }
        return this.getOptionalInfo().backupOps == null ? 0 : this.getOptionalInfo().backupOps.size();
    }

    @Override
    public SortedSet<VersionedBackupOp> getBackupOps() {
        return this.getOptionalInfo().backupOps;
    }

    @Override
    public void setBackupOps(SortedSet<VersionedBackupOp> backupOps) {
        if (backupOps != null) {
            this.getOptionalInfo().backupOps = backupOps;
        }
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    @Override
    public long getWriteTime() {
        return this.writeTime;
    }

    @Override
    public void setWriteTime(long writeTime) {
        this.writeTime = writeTime;
    }

    @Override
    public long getRemoveTime() {
        return this.removeTime;
    }

    @Override
    public void setRemoveTime(long removeTime) {
        this.removeTime = removeTime;
    }

    @Override
    public boolean hasScheduledAction() {
        return this.optionalInfo != null && this.optionalInfo.lsScheduledActions != null && this.optionalInfo.lsScheduledActions.size() > 0;
    }

    @Override
    public List<ScheduledAction> getScheduledActions() {
        if (this.optionalInfo == null) {
            return null;
        }
        return this.getOptionalInfo().lsScheduledActions;
    }

    @Override
    public void setScheduledActions(List<ScheduledAction> lsScheduledActions) {
        if (lsScheduledActions != null) {
            this.getOptionalInfo().lsScheduledActions = lsScheduledActions;
        }
    }

    @Override
    public Map<Address, Boolean> getListeners() {
        if (this.optionalInfo == null) {
            return null;
        }
        return this.getOptionalInfo().mapListeners;
    }

    @Override
    public void setMapListeners(Map<Address, Boolean> mapListeners) {
        if (mapListeners != null) {
            this.getOptionalInfo().mapListeners = mapListeners;
        }
    }

    @Override
    public boolean isLocked() {
        return this.lock != null && this.lock.isLocked();
    }

    @Override
    public int getScheduledActionCount() {
        if (this.optionalInfo == null) {
            return 0;
        }
        return this.getOptionalInfo().lsScheduledActions == null ? 0 : this.getOptionalInfo().lsScheduledActions.size();
    }

    @Override
    public int getLockCount() {
        return this.lock == null ? 0 : this.lock.getLockCount();
    }

    @Override
    public void clearLock() {
        this.lock = null;
    }

    @Override
    public Address getLockAddress() {
        return this.lock == null ? null : this.lock.getLockAddress();
    }

    @Override
    public OptionalInfo getOptionalInfo() {
        if (this.optionalInfo == null) {
            this.optionalInfo = new OptionalInfo();
        }
        return this.optionalInfo;
    }

    @Override
    public void setLastStoredTime(long lastStoredTime) {
        this.lastStoredTime = lastStoredTime;
    }

    @Override
    public long getLastStoredTime() {
        return this.lastStoredTime;
    }

    @Override
    public boolean isRemoved() {
        return !this.active && this.removeTime > 0L;
    }

    @Override
    public boolean isLoadable() {
        return !this.isRemoved() && (!this.isActive() || !this.isValid() || !this.hasValueData());
    }

    class OptionalInfo {
        volatile Collection<ValueHolder> lsMultiValues = null;
        Long[] indexes;
        byte[] indexTypes;
        List<ScheduledAction> lsScheduledActions = null;
        SortedSet<VersionedBackupOp> backupOps = null;
        Map<Address, Boolean> mapListeners = null;

        OptionalInfo() {
        }
    }
}

