/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.cluster.AbstractRemotelyProcessable;
import com.hazelcast.impl.partition.MigrationRequestTask;
import com.hazelcast.nio.Address;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class MigrationNotification
extends AbstractRemotelyProcessable {
    MigrationRequestTask migrationRequestTask;
    boolean started;

    public MigrationNotification() {
    }

    public MigrationNotification(boolean started, MigrationRequestTask migrationRequestTask) {
        this.started = started;
        this.migrationRequestTask = migrationRequestTask;
    }

    @Override
    public void process() {
        Address from = this.migrationRequestTask.getFromAddress();
        Address to = this.migrationRequestTask.getToAddress();
        int partitionId = this.migrationRequestTask.getPartitionId();
        this.node.concurrentMapManager.getPartitionManager().fireMigrationEvent(this.started, partitionId, from, to);
    }

    @Override
    public void readData(DataInput in) throws IOException {
        super.readData(in);
        this.migrationRequestTask = new MigrationRequestTask();
        this.migrationRequestTask.readData(in);
        this.started = in.readBoolean();
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        super.writeData(out);
        this.migrationRequestTask.writeData(out);
        out.writeBoolean(this.started);
    }
}

