/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.cache;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Instance;
import com.hazelcast.spring.cache.HazelcastCache;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HazelcastCacheManager
implements CacheManager,
InitializingBean {
    private final ConcurrentMap<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    private HazelcastInstance hazelcastInstance;

    public HazelcastCacheManager() {
    }

    public HazelcastCacheManager(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public void afterPropertiesSet() throws Exception {
        Collection<Instance> instances = this.hazelcastInstance.getInstances();
        for (Instance instance : instances) {
            if (instance.getInstanceType() != Instance.InstanceType.MAP) continue;
            IMap map = (IMap)instance;
            this.caches.put(map.getName(), new HazelcastCache(map));
        }
    }

    public Cache getCache(String name) {
        IMap<Object, Object> map;
        Cache currentCache;
        Cache cache = (Cache)this.caches.get(name);
        if (cache == null && (currentCache = this.caches.putIfAbsent(name, cache = new HazelcastCache(map = this.hazelcastInstance.getMap(name)))) != null) {
            cache = currentCache;
        }
        return cache;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    public Collection<String> getCacheNames() {
        return Collections.unmodifiableCollection(this.caches.keySet());
    }
}

