/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.AbstractRemotelyCallable;
import com.hazelcast.cluster.MemberInfo;
import com.hazelcast.impl.MemberImpl;
import com.hazelcast.util.Clock;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembersUpdateCall
extends AbstractRemotelyCallable<Boolean> {
    private static final long serialVersionUID = -2311579721761844861L;
    private Collection<MemberInfo> memberInfos;
    private long masterTime = Clock.currentTimeMillis();

    public MembersUpdateCall() {
        this.memberInfos = new ArrayList<MemberInfo>();
    }

    public MembersUpdateCall(Collection<MemberImpl> lsMembers, long masterTime) {
        this.masterTime = masterTime;
        this.memberInfos = new ArrayList<MemberInfo>(lsMembers.size());
        for (MemberImpl member : lsMembers) {
            this.memberInfos.add(new MemberInfo(member.getAddress(), member.getNodeType(), member.getUuid()));
        }
    }

    @Override
    public Boolean call() {
        this.node.getClusterImpl().setMasterTime(this.masterTime);
        this.node.clusterManager.updateMembers(this.getMemberInfos());
        return Boolean.TRUE;
    }

    public void addMemberInfo(MemberInfo memberInfo) {
        if (!this.memberInfos.contains(memberInfo)) {
            this.memberInfos.add(memberInfo);
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.masterTime = in.readLong();
        int size = in.readInt();
        this.memberInfos = new ArrayList<MemberInfo>(size);
        while (size-- > 0) {
            MemberInfo memberInfo = new MemberInfo();
            memberInfo.readData(in);
            this.memberInfos.add(memberInfo);
        }
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        out.writeLong(this.masterTime);
        out.writeInt(this.memberInfos.size());
        for (MemberInfo memberInfo : this.memberInfos) {
            memberInfo.writeData(out);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MembersUpdateCall {\n");
        for (MemberInfo address : this.memberInfos) {
            sb.append(address).append('\n');
        }
        sb.append('}');
        return sb.toString();
    }

    public Collection<MemberInfo> getMemberInfos() {
        return Collections.unmodifiableCollection(this.memberInfos);
    }
}

