/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.web;

import com.hazelcast.client.ClientConfig;
import com.hazelcast.client.ClientConfigBuilder;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.UrlXmlConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;

class HazelcastInstanceLoader {
    private static final ILogger logger = Logger.getLogger(HazelcastInstanceLoader.class.getName());
    public static final String INSTANCE_NAME = "instance-name";
    public static final String CONFIG_LOCATION = "config-location";
    public static final String USE_CLIENT = "use-client";
    public static final String CLIENT_CONFIG_LOCATION = "client-config-location";

    HazelcastInstanceLoader() {
    }

    public static HazelcastInstance createInstance(FilterConfig filterConfig, Properties properties) throws ServletException {
        Config config;
        String instanceName = properties.getProperty(INSTANCE_NAME);
        String configLocation = properties.getProperty(CONFIG_LOCATION);
        String useClientProp = properties.getProperty(USE_CLIENT);
        String clientConfigLocation = properties.getProperty(CLIENT_CONFIG_LOCATION);
        boolean useClient = !HazelcastInstanceLoader.isEmpty(useClientProp) && Boolean.parseBoolean(useClientProp);
        URL configUrl = null;
        if (useClient && !HazelcastInstanceLoader.isEmpty(clientConfigLocation)) {
            configUrl = HazelcastInstanceLoader.getConfigURL(filterConfig, clientConfigLocation);
        } else if (!HazelcastInstanceLoader.isEmpty(configLocation)) {
            configUrl = HazelcastInstanceLoader.getConfigURL(filterConfig, configLocation);
        }
        if (useClient) {
            ClientConfig clientConfig;
            logger.log(Level.WARNING, "Creating HazelcastClient, make sure this node has access to an already running cluster...");
            if (configUrl == null) {
                clientConfig = new ClientConfig();
                clientConfig.setUpdateAutomatic(true);
                clientConfig.setInitialConnectionAttemptLimit(3);
                clientConfig.setReconnectionAttemptLimit(5);
            } else {
                try {
                    clientConfig = new ClientConfigBuilder(configUrl).build();
                }
                catch (IOException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            return HazelcastClient.newHazelcastClient(clientConfig);
        }
        if (configUrl == null && HazelcastInstanceLoader.isEmpty(instanceName)) {
            return Hazelcast.getDefaultInstance();
        }
        if (configUrl == null) {
            config = new XmlConfigBuilder().build();
        } else {
            try {
                config = new UrlXmlConfig(configUrl);
            }
            catch (IOException e) {
                throw new ServletException((Throwable)e);
            }
        }
        if (!HazelcastInstanceLoader.isEmpty(instanceName)) {
            config.setInstanceName(instanceName);
            HazelcastInstance instance = Hazelcast.getHazelcastInstanceByName(instanceName);
            if (instance == null) {
                try {
                    instance = Hazelcast.newHazelcastInstance(config);
                }
                catch (DuplicateInstanceNameException ignored) {
                    instance = Hazelcast.getHazelcastInstanceByName(instanceName);
                }
            }
            return instance;
        }
        return Hazelcast.newHazelcastInstance(config);
    }

    private static URL getConfigURL(FilterConfig filterConfig, String configLocation) throws ServletException {
        URL configUrl = null;
        try {
            configUrl = filterConfig.getServletContext().getResource(configLocation);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (configUrl == null) {
            configUrl = ConfigLoader.locateConfig(configLocation);
        }
        if (configUrl == null) {
            throw new ServletException("Could not load configuration '" + configLocation + "'");
        }
        return configUrl;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

