/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.region;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.hibernate.region.AbstractHazelcastRegion;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.GeneralDataRegion;

public abstract class AbstractGeneralRegion
extends AbstractHazelcastRegion
implements GeneralDataRegion {
    protected AbstractGeneralRegion(HazelcastInstance instance, String name, Properties props) {
        super(instance, name, props);
    }

    public void evict(Object key) throws CacheException {
        try {
            this.getCache().remove(key);
        }
        catch (OperationTimeoutException operationTimeoutException) {
            // empty catch block
        }
    }

    public void evictAll() throws CacheException {
        try {
            this.getCache().clear();
        }
        catch (OperationTimeoutException operationTimeoutException) {
            // empty catch block
        }
    }

    public Object get(Object key) throws CacheException {
        try {
            return this.getCache().get(key);
        }
        catch (OperationTimeoutException e) {
            return null;
        }
    }

    public void put(Object key, Object value) throws CacheException {
        try {
            this.getCache().set(key, value, 0L, TimeUnit.MILLISECONDS);
        }
        catch (OperationTimeoutException operationTimeoutException) {
            // empty catch block
        }
    }
}

