/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spring.context;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.impl.DistributedRunnableAdapter;
import com.hazelcast.spring.context.SpringAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringManagedContext
implements ManagedContext,
ApplicationContextAware {
    private AutowireCapableBeanFactory beanFactory;

    public Object initialize(Object obj) {
        if (obj != null) {
            if (obj instanceof DistributedRunnableAdapter) {
                DistributedRunnableAdapter adapter = (DistributedRunnableAdapter)obj;
                Object runnable = adapter.getRunnable();
                runnable = this.initializeIfSpringAwareIsPresent(runnable);
                adapter.setRunnable((Runnable)runnable);
            } else {
                obj = this.initializeIfSpringAwareIsPresent(obj);
            }
        }
        return obj;
    }

    private Object initializeIfSpringAwareIsPresent(Object obj) {
        Class<?> clazz = obj.getClass();
        if (clazz.isAnnotationPresent(SpringAware.class)) {
            String name = clazz.getName();
            this.beanFactory.autowireBean(obj);
            obj = this.beanFactory.initializeBean(obj, name);
        }
        return obj;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = applicationContext.getAutowireCapableBeanFactory();
    }
}

