/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.impl.partition;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.impl.FactoryImpl;
import com.hazelcast.impl.Node;
import com.hazelcast.impl.PartitionManager;
import com.hazelcast.impl.Record;
import com.hazelcast.impl.base.DataRecordEntry;
import com.hazelcast.impl.base.RecordSet;
import com.hazelcast.impl.concurrentmap.CostAwareRecordList;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.DataSerializable;
import com.hazelcast.nio.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrationTask
implements Callable<Boolean>,
DataSerializable,
HazelcastInstanceAware {
    private int partitionId;
    private int replicaIndex;
    private byte[] bytesRecordSet;
    private Address from;
    private int recordCount;
    private transient HazelcastInstance hazelcast;

    public MigrationTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MigrationTask(int partitionId, CostAwareRecordList costAwareRecordList, int replicaIndex, Address from, boolean compress) throws IOException {
        this.partitionId = partitionId;
        this.replicaIndex = replicaIndex;
        this.from = from;
        this.recordCount = costAwareRecordList.getRecords().size();
        ByteArrayOutputStream bos = new ByteArrayOutputStream((int)(costAwareRecordList.getCost() / 100L));
        DataOutputStream dos = null;
        try {
            bos.write(compress ? 1 : 0);
            dos = compress ? new DataOutputStream(new DeflaterOutputStream(bos)) : new DataOutputStream(bos);
            List<Record> lsRecordsToMigrate = costAwareRecordList.getRecords();
            dos.writeInt(lsRecordsToMigrate.size());
            for (Record record : lsRecordsToMigrate) {
                new DataRecordEntry(record, true).writeData(dos);
            }
            Object var12_11 = null;
        }
        catch (Throwable throwable) {
            Object var12_12 = null;
            IOUtil.closeResource(dos);
            throw throwable;
        }
        IOUtil.closeResource(dos);
        this.bytesRecordSet = bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Boolean call() throws Exception {
        Boolean bl;
        Node node = ((FactoryImpl)this.hazelcast).node;
        PartitionManager pm = node.concurrentMapManager.getPartitionManager();
        DataInputStream dis = null;
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(this.bytesRecordSet);
            boolean compressed = bais.read() != 0;
            dis = compressed ? new DataInputStream(new InflaterInputStream(bais)) : new DataInputStream(bais);
            int size = dis.readInt();
            RecordSet recordSet = new RecordSet();
            for (int i = 0; i < size; ++i) {
                DataRecordEntry r = new DataRecordEntry();
                r.readData(dis);
                recordSet.addDataRecordEntry(r);
            }
            if (this.recordCount != recordSet.getRecords().size()) {
                this.getLogger().log(Level.SEVERE, "Migration record count mismatch! => expected-count: " + size + ", actual-count: " + recordSet.getRecords().size() + "\nfrom: " + this.from + ", partition: " + this.partitionId + ", replica: " + this.replicaIndex);
            }
            pm.doMigrate(this.partitionId, this.replicaIndex, recordSet, this.from);
            bl = Boolean.TRUE;
            Object var11_13 = null;
        }
        catch (Throwable e) {
            try {
                Level level = Level.WARNING;
                if (e instanceof IllegalStateException) {
                    level = Level.FINEST;
                }
                this.getLogger().log(level, e.getMessage(), e);
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                IOUtil.closeResource(dis);
                throw throwable;
            }
            IOUtil.closeResource(dis);
            return Boolean.FALSE;
        }
        IOUtil.closeResource(dis);
        return bl;
    }

    private ILogger getLogger() {
        return ((FactoryImpl)this.hazelcast).node.getLogger(MigrationTask.class.getName());
    }

    @Override
    public void writeData(DataOutput out) throws IOException {
        try {
            out.writeInt(this.partitionId);
            out.writeInt(this.replicaIndex);
            out.writeInt(this.recordCount);
            this.from.writeData(out);
            out.writeInt(this.bytesRecordSet.length);
            out.write(this.bytesRecordSet);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void readData(DataInput in) throws IOException {
        this.partitionId = in.readInt();
        this.replicaIndex = in.readInt();
        this.recordCount = in.readInt();
        this.from = new Address();
        this.from.readData(in);
        int size = in.readInt();
        this.bytesRecordSet = new byte[size];
        in.readFully(this.bytesRecordSet);
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcast = hazelcastInstance;
    }
}

