/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi;

import com.hazelcast.client.exception.ClientException;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.ResponseHandler;
import com.hazelcast.client.spi.ResponseStream;
import com.hazelcast.nio.serialization.Data;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ListenerSupport {
    private final ClientContext context;
    private final EventHandler handler;
    private final Object registrationRequest;
    private Future<?> future;
    private volatile boolean active = true;
    private volatile ResponseStream lastStream;
    private Data key;
    final CountDownLatch latch = new CountDownLatch(1);

    public ListenerSupport(ClientContext context, Object registrationRequest, EventHandler handler) {
        this.context = context;
        this.registrationRequest = registrationRequest;
        this.handler = handler;
    }

    public ListenerSupport(ClientContext context, Object registrationRequest, EventHandler handler, Data key) {
        this(context, registrationRequest, handler);
        this.key = key;
    }

    public String listen() {
        this.future = this.context.getExecutionService().submit(new Runnable(){

            @Override
            public void run() {
                while (ListenerSupport.this.active && !Thread.currentThread().isInterrupted()) {
                    try {
                        EventResponseHandler eventResponseHandler = new EventResponseHandler();
                        if (ListenerSupport.this.key == null) {
                            ListenerSupport.this.context.getInvocationService().invokeOnRandomTarget(ListenerSupport.this.registrationRequest, eventResponseHandler);
                            continue;
                        }
                        ListenerSupport.this.context.getInvocationService().invokeOnKeyOwner(ListenerSupport.this.registrationRequest, ListenerSupport.this.key, eventResponseHandler);
                    }
                    catch (Exception exception) {}
                }
            }
        });
        try {
            if (!this.latch.await(1L, TimeUnit.MINUTES)) {
                throw new ClientException("Could not register listener!!!");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return UUID.randomUUID().toString();
    }

    public void stop() {
        ResponseStream s;
        this.active = false;
        if (this.future != null) {
            this.future.cancel(true);
        }
        if ((s = this.lastStream) != null) {
            try {
                s.end();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class EventResponseHandler
    implements ResponseHandler {
        private EventResponseHandler() {
        }

        @Override
        public void handle(ResponseStream stream) throws Exception {
            stream.read();
            ListenerSupport.this.lastStream = stream;
            ListenerSupport.this.latch.countDown();
            while (ListenerSupport.this.active && !Thread.currentThread().isInterrupted()) {
                try {
                    Object event = stream.read();
                    ListenerSupport.this.handler.handle(event);
                }
                catch (Exception e) {
                    try {
                        stream.end();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (!(e instanceof IOException)) {
                        ListenerSupport.this.active = false;
                        continue;
                    }
                    throw e;
                }
            }
        }
    }
}

