/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection;

import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionEvent;
import com.hazelcast.collection.CollectionEventFilter;
import com.hazelcast.collection.CollectionMigrationOperation;
import com.hazelcast.collection.CollectionPartitionContainer;
import com.hazelcast.collection.CollectionProxy;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionProxyType;
import com.hazelcast.collection.CollectionWrapper;
import com.hazelcast.collection.list.ObjectListProxy;
import com.hazelcast.collection.list.tx.TransactionalListProxy;
import com.hazelcast.collection.multimap.ObjectMultiMapProxy;
import com.hazelcast.collection.multimap.tx.TransactionalMultiMapProxy;
import com.hazelcast.collection.set.ObjectSetProxy;
import com.hazelcast.collection.set.tx.TransactionalSetProxy;
import com.hazelcast.concurrent.lock.LockService;
import com.hazelcast.concurrent.lock.LockStoreInfo;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemEventType;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.Member;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.monitor.impl.LocalMultiMapStatsImpl;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.partition.MigrationEndpoint;
import com.hazelcast.partition.PartitionView;
import com.hazelcast.spi.EventPublishingService;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.EventService;
import com.hazelcast.spi.ManagedService;
import com.hazelcast.spi.MigrationAwareService;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.PartitionMigrationEvent;
import com.hazelcast.spi.PartitionReplicationEvent;
import com.hazelcast.spi.RemoteService;
import com.hazelcast.spi.TransactionalService;
import com.hazelcast.transaction.TransactionalObject;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CollectionService
implements ManagedService,
RemoteService,
MigrationAwareService,
EventPublishingService<CollectionEvent, EventListener>,
TransactionalService {
    public static final String SERVICE_NAME = "hz:impl:collectionService";
    private final NodeEngine nodeEngine;
    private final CollectionPartitionContainer[] partitionContainers;
    private final ConcurrentMap<CollectionProxyId, LocalMultiMapStatsImpl> statsMap = new ConcurrentHashMap<CollectionProxyId, LocalMultiMapStatsImpl>(1000);
    private final ConstructorFunction<CollectionProxyId, LocalMultiMapStatsImpl> localMultiMapStatsConstructorFunction = new ConstructorFunction<CollectionProxyId, LocalMultiMapStatsImpl>(){

        @Override
        public LocalMultiMapStatsImpl createNew(CollectionProxyId key) {
            return new LocalMultiMapStatsImpl();
        }
    };

    public CollectionService(NodeEngine nodeEngine) {
        this.nodeEngine = nodeEngine;
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        this.partitionContainers = new CollectionPartitionContainer[partitionCount];
    }

    @Override
    public void init(final NodeEngine nodeEngine, Properties properties) {
        int partitionCount = nodeEngine.getPartitionService().getPartitionCount();
        for (int i = 0; i < partitionCount; ++i) {
            this.partitionContainers[i] = new CollectionPartitionContainer(this, i);
        }
        LockService lockService = (LockService)nodeEngine.getSharedService("hz:impl:lockService");
        if (lockService != null) {
            lockService.registerLockStoreConstructor(SERVICE_NAME, new ConstructorFunction<ObjectNamespace, LockStoreInfo>(){

                @Override
                public LockStoreInfo createNew(final ObjectNamespace key) {
                    CollectionProxyId id = (CollectionProxyId)key.getObjectId();
                    final MultiMapConfig multiMapConfig = nodeEngine.getConfig().getMultiMapConfig(id.getName());
                    return new LockStoreInfo(){

                        @Override
                        public ObjectNamespace getObjectNamespace() {
                            return key;
                        }

                        @Override
                        public int getBackupCount() {
                            return multiMapConfig.getSyncBackupCount();
                        }

                        @Override
                        public int getAsyncBackupCount() {
                            return multiMapConfig.getAsyncBackupCount();
                        }
                    };
                }
            });
        }
    }

    @Override
    public void reset() {
        for (CollectionPartitionContainer container : this.partitionContainers) {
            if (container == null) continue;
            container.destroy();
        }
    }

    @Override
    public void shutdown() {
        this.reset();
        for (int i = 0; i < this.partitionContainers.length; ++i) {
            this.partitionContainers[i] = null;
        }
    }

    public CollectionContainer getOrCreateCollectionContainer(int partitionId, CollectionProxyId proxyId) {
        return this.partitionContainers[partitionId].getOrCreateCollectionContainer(proxyId);
    }

    public CollectionPartitionContainer getPartitionContainer(int partitionId) {
        return this.partitionContainers[partitionId];
    }

    <V> Collection<V> createNew(CollectionProxyId proxyId) {
        CollectionProxy proxy = (CollectionProxy)this.nodeEngine.getProxyService().getDistributedObject(SERVICE_NAME, proxyId);
        return proxy.createNew();
    }

    @Override
    public DistributedObject createDistributedObject(Object objectId) {
        CollectionProxyId collectionProxyId = (CollectionProxyId)objectId;
        CollectionProxyType type = collectionProxyId.type;
        switch (type) {
            case MULTI_MAP: {
                return new ObjectMultiMapProxy(this, this.nodeEngine, collectionProxyId);
            }
            case LIST: {
                return new ObjectListProxy(this, this.nodeEngine, collectionProxyId);
            }
            case SET: {
                return new ObjectSetProxy(this, this.nodeEngine, collectionProxyId);
            }
            case QUEUE: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void destroyDistributedObject(Object objectId) {
        CollectionProxyId collectionProxyId = (CollectionProxyId)objectId;
        for (CollectionPartitionContainer container : this.partitionContainers) {
            if (container == null) continue;
            container.destroyCollection(collectionProxyId);
        }
    }

    public Set<Data> localKeySet(CollectionProxyId proxyId) {
        HashSet<Data> keySet = new HashSet<Data>();
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.nodeEngine.getClusterService();
        Address thisAddress = clusterService.getThisAddress();
        for (int i = 0; i < this.nodeEngine.getPartitionService().getPartitionCount(); ++i) {
            PartitionView partition = this.nodeEngine.getPartitionService().getPartitionView(i);
            CollectionPartitionContainer partitionContainer = this.getPartitionContainer(i);
            CollectionContainer collectionContainer = partitionContainer.getCollectionContainer(proxyId);
            if (collectionContainer == null || !partition.getOwner().equals(thisAddress)) continue;
            keySet.addAll(collectionContainer.keySet());
        }
        this.getLocalMultiMapStatsImpl(proxyId).incrementOtherOperations();
        return keySet;
    }

    public SerializationService getSerializationService() {
        return this.nodeEngine.getSerializationService();
    }

    public NodeEngine getNodeEngine() {
        return this.nodeEngine;
    }

    public String addListener(String name, EventListener listener, Data key, boolean includeValue, boolean local) {
        EventService eventService = this.nodeEngine.getEventService();
        EventRegistration registration = local ? eventService.registerLocalListener(SERVICE_NAME, name, new CollectionEventFilter(includeValue, key), listener) : eventService.registerListener(SERVICE_NAME, name, new CollectionEventFilter(includeValue, key), listener);
        return registration.getId();
    }

    public boolean removeListener(String name, String registrationId) {
        EventService eventService = this.nodeEngine.getEventService();
        return eventService.deregisterListener(SERVICE_NAME, name, registrationId);
    }

    @Override
    public void dispatchEvent(CollectionEvent event, EventListener listener) {
        if (listener instanceof EntryListener) {
            EntryListener entryListener = (EntryListener)listener;
            EntryEvent entryEvent = new EntryEvent(event.getProxyId().getName(), this.nodeEngine.getClusterService().getMember(event.getCaller()), event.getEventType().getType(), this.nodeEngine.toObject(event.getKey()), this.nodeEngine.toObject(event.getValue()));
            if (event.eventType.equals((Object)EntryEventType.ADDED)) {
                entryListener.entryAdded(entryEvent);
            } else if (event.eventType.equals((Object)EntryEventType.REMOVED)) {
                entryListener.entryRemoved(entryEvent);
            }
            this.getLocalMultiMapStatsImpl(event.getProxyId()).incrementReceivedEvents();
        } else if (listener instanceof ItemListener) {
            ItemListener itemListener = (ItemListener)listener;
            ItemEvent itemEvent = new ItemEvent(event.getProxyId().getName(), event.eventType.getType(), this.nodeEngine.toObject(event.getValue()), (Member)this.nodeEngine.getClusterService().getMember(event.getCaller()));
            if (event.eventType.getType() == ItemEventType.ADDED.getType()) {
                itemListener.itemAdded(itemEvent);
            } else {
                itemListener.itemRemoved(itemEvent);
            }
        }
    }

    @Override
    public void beforeMigration(PartitionMigrationEvent partitionMigrationEvent) {
    }

    @Override
    public Operation prepareReplicationOperation(PartitionReplicationEvent event) {
        int replicaIndex = event.getReplicaIndex();
        CollectionPartitionContainer partitionContainer = this.partitionContainers[event.getPartitionId()];
        HashMap<CollectionProxyId, Map> map = new HashMap<CollectionProxyId, Map>(partitionContainer.containerMap.size());
        for (Map.Entry entry : partitionContainer.containerMap.entrySet()) {
            CollectionProxyId proxyId = (CollectionProxyId)entry.getKey();
            CollectionContainer container = (CollectionContainer)entry.getValue();
            if (container.config.getTotalBackupCount() < replicaIndex) continue;
            map.put(proxyId, container.collections);
        }
        if (map.isEmpty()) {
            return null;
        }
        return new CollectionMigrationOperation(map);
    }

    public void insertMigratedData(int partitionId, Map<CollectionProxyId, Map> map) {
        for (Map.Entry<CollectionProxyId, Map> entry : map.entrySet()) {
            CollectionProxyId proxyId = entry.getKey();
            CollectionContainer container = this.getOrCreateCollectionContainer(partitionId, proxyId);
            Map collections = entry.getValue();
            container.collections.putAll(collections);
        }
    }

    private void clearMigrationData(int partitionId) {
        CollectionPartitionContainer partitionContainer = this.partitionContainers[partitionId];
        partitionContainer.containerMap.clear();
    }

    @Override
    public void commitMigration(PartitionMigrationEvent event) {
        if (event.getMigrationEndpoint() == MigrationEndpoint.SOURCE) {
            this.clearMigrationData(event.getPartitionId());
        }
    }

    @Override
    public void rollbackMigration(PartitionMigrationEvent event) {
        this.clearMigrationData(event.getPartitionId());
    }

    @Override
    public void clearPartitionReplica(int partitionId) {
        this.clearMigrationData(partitionId);
    }

    public LocalMapStats createStats(CollectionProxyId proxyId) {
        LocalMultiMapStatsImpl stats = this.getLocalMultiMapStatsImpl(proxyId);
        long ownedEntryCount = 0L;
        long backupEntryCount = 0L;
        long dirtyCount = 0L;
        long ownedEntryMemoryCost = 0L;
        long backupEntryMemoryCost = 0L;
        long hits = 0L;
        long lockedEntryCount = 0L;
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.nodeEngine.getClusterService();
        Address thisAddress = clusterService.getThisAddress();
        for (int i = 0; i < this.nodeEngine.getPartitionService().getPartitionCount(); ++i) {
            PartitionView partition = this.nodeEngine.getPartitionService().getPartitionView(i);
            CollectionPartitionContainer partitionContainer = this.getPartitionContainer(i);
            CollectionContainer collectionContainer = partitionContainer.getCollectionContainer(proxyId);
            if (collectionContainer == null) continue;
            if (partition.getOwner().equals(thisAddress)) {
                lockedEntryCount += collectionContainer.getLockedCount();
                for (CollectionWrapper wrapper : collectionContainer.collections.values()) {
                    hits += (long)wrapper.getHits();
                    ownedEntryCount += (long)wrapper.getCollection().size();
                }
                continue;
            }
            int backupCount = collectionContainer.config.getTotalBackupCount();
            for (int j = 1; j <= backupCount; ++j) {
                Address replicaAddress = partition.getReplicaAddress(j);
                int memberSize = this.nodeEngine.getClusterService().getMembers().size();
                int tryCount = 3;
                while (memberSize > backupCount && replicaAddress == null && tryCount-- > 0) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        throw ExceptionUtil.rethrow(e);
                    }
                    replicaAddress = partition.getReplicaAddress(j);
                }
                if (replicaAddress == null || !replicaAddress.equals(thisAddress)) continue;
                for (CollectionWrapper wrapper : collectionContainer.collections.values()) {
                    backupEntryCount += (long)wrapper.getCollection().size();
                }
            }
        }
        stats.setOwnedEntryCount(ownedEntryCount);
        stats.setBackupEntryCount(backupEntryCount);
        stats.setHits(hits);
        stats.setLockedEntryCount(lockedEntryCount);
        return stats;
    }

    public LocalMultiMapStatsImpl getLocalMultiMapStatsImpl(CollectionProxyId name) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.statsMap, name, this.localMultiMapStatsConstructorFunction);
    }

    @Override
    public <T extends TransactionalObject> T createTransactionalObject(Object id, Transaction transaction) {
        CollectionProxyId collectionProxyId = (CollectionProxyId)id;
        CollectionProxyType type = collectionProxyId.type;
        switch (type) {
            case MULTI_MAP: {
                return (T)new TransactionalMultiMapProxy(this.nodeEngine, this, collectionProxyId, transaction);
            }
            case LIST: {
                return (T)new TransactionalListProxy(this.nodeEngine, this, collectionProxyId, transaction);
            }
            case SET: {
                return (T)new TransactionalSetProxy(this.nodeEngine, this, collectionProxyId, transaction);
            }
            case QUEUE: {
                return null;
            }
        }
        throw new IllegalArgumentException();
    }
}

