/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.operations.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.collection.CollectionPortableHook;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.spi.impl.PortableEntryEvent;
import java.io.IOException;

public class AddEntryListenerRequest
extends CallableClientRequest
implements Portable {
    CollectionProxyId proxyId;
    Data key;
    boolean includeValue;
    private transient String registrationId;

    public AddEntryListenerRequest() {
    }

    public AddEntryListenerRequest(CollectionProxyId proxyId, Data key, boolean includeValue) {
        this.proxyId = proxyId;
        this.key = key;
        this.includeValue = includeValue;
    }

    public Object call() throws Exception {
        final ClientEndpoint endpoint = this.getEndpoint();
        final ClientEngine clientEngine = this.getClientEngine();
        final CollectionService service = (CollectionService)this.getService();
        EntryListener listener = new EntryListener(){

            public void entryAdded(EntryEvent event) {
                this.send(event);
            }

            public void entryRemoved(EntryEvent event) {
                this.send(event);
            }

            public void entryUpdated(EntryEvent event) {
                this.send(event);
            }

            public void entryEvicted(EntryEvent event) {
                this.send(event);
            }

            private void send(EntryEvent event) {
                if (endpoint.live()) {
                    Data key = clientEngine.toData(event.getKey());
                    Data value = clientEngine.toData(event.getValue());
                    Data oldValue = clientEngine.toData(event.getOldValue());
                    PortableEntryEvent portableEntryEvent = new PortableEntryEvent(key, value, oldValue, event.getEventType(), event.getMember().getUuid());
                    clientEngine.sendResponse(endpoint, portableEntryEvent);
                } else if (AddEntryListenerRequest.this.registrationId != null) {
                    service.removeListener(AddEntryListenerRequest.this.proxyId.getName(), AddEntryListenerRequest.this.registrationId);
                } else {
                    System.err.println("registrationId is null!!!");
                }
            }
        };
        this.registrationId = service.addListener(this.proxyId.getName(), listener, this.key, this.includeValue, false);
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:collectionService";
    }

    @Override
    public int getFactoryId() {
        return CollectionPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 20;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeBoolean("i", this.includeValue);
        ObjectDataOutput out = writer.getRawDataOutput();
        this.proxyId.writeData(out);
        IOUtil.writeNullableData(out, this.key);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.includeValue = reader.readBoolean("i");
        ObjectDataInput in = reader.getRawDataInput();
        this.proxyId = new CollectionProxyId();
        this.proxyId.readData(in);
        this.key = IOUtil.readNullableData(in);
    }
}

