/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.LockStore;
import com.hazelcast.concurrent.lock.LockStoreContainer;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.ObjectNamespace;
import java.util.Set;

public final class LockStoreProxy
implements LockStore {
    private final LockStoreContainer container;
    private final ObjectNamespace namespace;

    public LockStoreProxy(LockStoreContainer container, ObjectNamespace namespace) {
        this.container = container;
        this.namespace = namespace;
    }

    @Override
    public boolean lock(Data key, String caller, int threadId, long ttl) {
        return this.getLockStore().lock(key, caller, threadId, ttl);
    }

    @Override
    public boolean txnLock(Data key, String caller, int threadId, long ttl) {
        return this.getLockStore().txnLock(key, caller, threadId, ttl);
    }

    @Override
    public boolean extendLeaseTime(Data key, String caller, int threadId, long ttl) {
        return this.getLockStore().extendLeaseTime(key, caller, threadId, ttl);
    }

    @Override
    public boolean unlock(Data key, String caller, int threadId) {
        return this.getLockStore().unlock(key, caller, threadId);
    }

    @Override
    public boolean isLocked(Data key) {
        return this.getLockStore().isLocked(key);
    }

    @Override
    public boolean isLockedBy(Data key, String caller, int threadId) {
        return this.getLockStore().isLockedBy(key, caller, threadId);
    }

    @Override
    public int getLockCount(Data key) {
        return this.getLockStore().getLockCount(key);
    }

    @Override
    public long getRemainingLeaseTime(Data key) {
        return this.getLockStore().getRemainingLeaseTime(key);
    }

    @Override
    public boolean canAcquireLock(Data key, String caller, int threadId) {
        return this.getLockStore().canAcquireLock(key, caller, threadId);
    }

    @Override
    public Set<Data> getLockedKeys() {
        return this.getLockStore().getLockedKeys();
    }

    @Override
    public boolean forceUnlock(Data key) {
        return this.getLockStore().forceUnlock(key);
    }

    private LockStore getLockStore() {
        return this.container.getLockStore(this.namespace);
    }
}

