/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock.proxy;

import com.hazelcast.concurrent.lock.AwaitOperation;
import com.hazelcast.concurrent.lock.BeforeAwaitOperation;
import com.hazelcast.concurrent.lock.SignalOperation;
import com.hazelcast.concurrent.lock.proxy.LockProxy;
import com.hazelcast.core.ICondition;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.ThreadUtil;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public final class ConditionImpl
implements ICondition {
    private final LockProxy lockProxy;
    private final int partitionId;
    private final String conditionId;

    public ConditionImpl(LockProxy lockProxy, String id) {
        this.lockProxy = lockProxy;
        this.partitionId = lockProxy.getNodeEngine().getPartitionService().getPartitionId(lockProxy.key);
        this.conditionId = id;
    }

    @Override
    public void await() throws InterruptedException {
        this.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    @Override
    public void awaitUninterruptibly() {
        try {
            this.await(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            ExceptionUtil.sneakyThrow(e);
        }
    }

    @Override
    public long awaitNanos(long nanosTimeout) throws InterruptedException {
        long start = System.nanoTime();
        this.await(nanosTimeout, TimeUnit.NANOSECONDS);
        long end = System.nanoTime();
        return end - start;
    }

    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        NodeEngine nodeEngine = this.lockProxy.getNodeEngine();
        int threadId = ThreadUtil.getThreadId();
        Invocation inv1 = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:lockService", (Operation)new BeforeAwaitOperation((ObjectNamespace)this.lockProxy.namespace, this.lockProxy.key, threadId, this.conditionId), this.partitionId).build();
        try {
            Future f = inv1.invoke();
            f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        Invocation inv2 = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:lockService", (Operation)new AwaitOperation((ObjectNamespace)this.lockProxy.namespace, this.lockProxy.key, threadId, unit.toMillis(time), this.conditionId), this.partitionId).build();
        try {
            Future f = inv2.invoke();
            return Boolean.TRUE.equals(f.get());
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrowAllowInterrupted(t);
        }
    }

    @Override
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        long until = deadline.getTime();
        return this.await(until - Clock.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public void signal() {
        this.signal(false);
    }

    private void signal(boolean all) {
        NodeEngine nodeEngine = this.lockProxy.getNodeEngine();
        Invocation inv = nodeEngine.getOperationService().createInvocationBuilder("hz:impl:lockService", (Operation)new SignalOperation((ObjectNamespace)this.lockProxy.namespace, this.lockProxy.key, ThreadUtil.getThreadId(), this.conditionId, all), this.partitionId).build();
        Future f = inv.invoke();
        try {
            f.get();
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    @Override
    public void signalAll() {
        this.signal(true);
    }
}

