/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class TcpIpConfig {
    private int connectionTimeoutSeconds = 5;
    private boolean enabled = false;
    private List<String> members = new ArrayList<String>();
    private String requiredMember = null;

    public TcpIpConfig addMember(String member) {
        this.members.add(member);
        return this;
    }

    public TcpIpConfig clear() {
        this.members.clear();
        return this;
    }

    public int getConnectionTimeoutSeconds() {
        return this.connectionTimeoutSeconds;
    }

    public TcpIpConfig setConnectionTimeoutSeconds(int connectionTimeoutSeconds) {
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public TcpIpConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public List<String> getMembers() {
        if (this.members == null) {
            this.members = new ArrayList<String>();
        }
        return this.members;
    }

    public TcpIpConfig setMembers(List<String> members) {
        this.members.clear();
        for (String member : members) {
            StringTokenizer tokenizer = new StringTokenizer(member, ",");
            while (tokenizer.hasMoreTokens()) {
                String s = tokenizer.nextToken();
                this.members.add(s.trim());
            }
        }
        return this;
    }

    public String getRequiredMember() {
        return this.requiredMember;
    }

    public TcpIpConfig setRequiredMember(String requiredMember) {
        this.requiredMember = requiredMember;
        return this;
    }

    public String toString() {
        return "TcpIpConfig [enabled=" + this.enabled + ", connectionTimeoutSeconds=" + this.connectionTimeoutSeconds + ", members=" + this.members + ", requiredMember=" + this.requiredMember + "]";
    }
}

