/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.ListenerConfig;
import java.util.ArrayList;
import java.util.List;

public final class TopicConfig {
    public static final boolean DEFAULT_GLOBAL_ORDERING_ENABLED = true;
    private String name;
    private boolean globalOrderingEnabled = true;
    private boolean statisticsEnabled = true;
    private List<ListenerConfig> listenerConfigs;

    public TopicConfig() {
    }

    public TopicConfig(TopicConfig config) {
        this.name = config.name;
        this.globalOrderingEnabled = config.globalOrderingEnabled;
        this.listenerConfigs = new ArrayList<ListenerConfig>(config.getMessageListenerConfigs());
    }

    public String getName() {
        return this.name;
    }

    public TopicConfig setName(String name) {
        this.name = name;
        return this;
    }

    public boolean isGlobalOrderingEnabled() {
        return this.globalOrderingEnabled;
    }

    public TopicConfig setGlobalOrderingEnabled(boolean globalOrderingEnabled) {
        this.globalOrderingEnabled = globalOrderingEnabled;
        return this;
    }

    public TopicConfig addMessageListenerConfig(ListenerConfig listenerConfig) {
        this.getMessageListenerConfigs().add(listenerConfig);
        return this;
    }

    public List<ListenerConfig> getMessageListenerConfigs() {
        if (this.listenerConfigs == null) {
            this.listenerConfigs = new ArrayList<ListenerConfig>();
        }
        return this.listenerConfigs;
    }

    public TopicConfig setMessageListenerConfigs(List<ListenerConfig> listenerConfigs) {
        this.listenerConfigs = listenerConfigs;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public TopicConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public int hashCode() {
        return (this.globalOrderingEnabled ? 1231 : 1237) + 31 * (this.name != null ? this.name.hashCode() : 0);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TopicConfig)) {
            return false;
        }
        TopicConfig other = (TopicConfig)obj;
        return (this.name != null ? this.name.equals(other.name) : other.name == null) && this.globalOrderingEnabled == other.globalOrderingEnabled;
    }

    public String toString() {
        return "TopicConfig [name=" + this.name + ", globalOrderingEnabled=" + this.globalOrderingEnabled + "]";
    }
}

