/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.core.Member;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.partition.MigrationStatus;
import java.io.IOException;

public class MigrationEvent
implements DataSerializable {
    private int partitionId;
    private Member oldOwner;
    private Member newOwner;
    private MigrationStatus status;

    public MigrationEvent() {
    }

    public MigrationEvent(int partitionId, Member oldOwner, Member newOwner, MigrationStatus status) {
        this.partitionId = partitionId;
        this.oldOwner = oldOwner;
        this.newOwner = newOwner;
        this.status = status;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public Member getOldOwner() {
        return this.oldOwner;
    }

    public Member getNewOwner() {
        return this.newOwner;
    }

    public MigrationStatus getStatus() {
        return this.status;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeInt(this.partitionId);
        this.oldOwner.writeData(out);
        this.newOwner.writeData(out);
        MigrationStatus.writeTo(this.status, out);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.partitionId = in.readInt();
        this.oldOwner = new MemberImpl();
        this.oldOwner.readData(in);
        this.newOwner = new MemberImpl();
        this.newOwner.readData(in);
        this.status = MigrationStatus.readFrom(in);
    }

    public String toString() {
        return "MigrationEvent{partitionId=" + this.partitionId + ", oldOwner=" + this.oldOwner + ", newOwner=" + this.newOwner + '}';
    }
}

