/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.config.Config;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.Member;
import com.hazelcast.instance.DefaultNodeContext;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.HazelcastInstanceProxy;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeContext;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.jmx.ManagementService;
import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

@PrivateApi
public final class HazelcastInstanceFactory {
    private static final ConcurrentMap<String, HazelcastInstanceProxy> INSTANCE_MAP = new ConcurrentHashMap<String, HazelcastInstanceProxy>(5);
    private static final AtomicInteger factoryIdGen = new AtomicInteger();
    private static final Object INSTANCE_NAME_LOCK = new Object();

    public static Set<HazelcastInstance> getAllHazelcastInstances() {
        return new HashSet<HazelcastInstance>(INSTANCE_MAP.values());
    }

    public static HazelcastInstance getHazelcastInstance(String instanceName) {
        return (HazelcastInstance)INSTANCE_MAP.get(instanceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HazelcastInstance newHazelcastInstance(Config config) {
        String name;
        if (config == null) {
            config = new XmlConfigBuilder().build();
        }
        if ((name = config.getInstanceName()) == null || name.trim().length() == 0) {
            name = HazelcastInstanceFactory.createInstanceName(config);
            return HazelcastInstanceFactory.newHazelcastInstance(config, name, new DefaultNodeContext());
        }
        Object object = INSTANCE_NAME_LOCK;
        synchronized (object) {
            if (INSTANCE_MAP.containsKey(name)) {
                throw new DuplicateInstanceNameException("HazelcastInstance with name '" + name + "' already exists!");
            }
            factoryIdGen.incrementAndGet();
            return HazelcastInstanceFactory.newHazelcastInstance(config, name, new DefaultNodeContext());
        }
    }

    private static String createInstanceName(Config config) {
        return "_hzInstance_" + factoryIdGen.incrementAndGet() + "_" + config.getGroupConfig().getName();
    }

    public static HazelcastInstance newHazelcastInstance(Config config, String instanceName, NodeContext nodeContext) {
        HazelcastInstanceProxy proxy;
        if (instanceName == null || instanceName.trim().length() == 0) {
            instanceName = HazelcastInstanceFactory.createInstanceName(config);
        }
        try {
            HazelcastInstanceImpl hazelcastInstance = new HazelcastInstanceImpl(instanceName, config, nodeContext);
            OutOfMemoryErrorDispatcher.register(hazelcastInstance);
            proxy = new HazelcastInstanceProxy(hazelcastInstance);
            INSTANCE_MAP.put(instanceName, proxy);
            Node node = hazelcastInstance.node;
            Iterator iter = node.getClusterService().getMembers().iterator();
            boolean firstMember = iter.hasNext() && ((Member)iter.next()).localMember();
            int initialWaitSeconds = node.groupProperties.INITIAL_WAIT_SECONDS.getInteger();
            if (initialWaitSeconds > 0) {
                try {
                    Thread.sleep(initialWaitSeconds * 1000);
                    if (firstMember) {
                        node.partitionService.firstArrangement();
                    } else {
                        Thread.sleep(4000L);
                    }
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
            }
            int initialMinClusterSize = node.groupProperties.INITIAL_MIN_CLUSTER_SIZE.getInteger();
            while (node.getClusterService().getSize() < initialMinClusterSize) {
                try {
                    hazelcastInstance.logger.log(Level.INFO, "HazelcastInstance waiting for cluster size of " + initialMinClusterSize);
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignored) {}
            }
            if (initialMinClusterSize > 0) {
                if (firstMember) {
                    node.partitionService.firstArrangement();
                } else {
                    Thread.sleep(3000L);
                }
            }
            hazelcastInstance.lifecycleService.fireLifecycleEvent(LifecycleEvent.LifecycleState.STARTED);
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
        return proxy;
    }

    public static void shutdownAll() {
        ArrayList instances = new ArrayList(INSTANCE_MAP.values());
        INSTANCE_MAP.clear();
        ManagementService.shutdownAll();
        Collections.sort(instances, new Comparator<HazelcastInstanceProxy>(){

            @Override
            public int compare(HazelcastInstanceProxy o1, HazelcastInstanceProxy o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (HazelcastInstanceProxy proxy : instances) {
            proxy.getLifecycleService().shutdown();
            proxy.original = null;
        }
    }

    static void remove(HazelcastInstanceImpl instance) {
        OutOfMemoryErrorDispatcher.deregister(instance);
        HazelcastInstanceProxy proxy = (HazelcastInstanceProxy)INSTANCE_MAP.remove(instance.getName());
        if (proxy != null) {
            proxy.original = null;
        }
        if (INSTANCE_MAP.size() == 0) {
            ManagementService.shutdownAll();
        }
    }
}

