/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.Member;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;

public final class MemberImpl
implements Member,
HazelcastInstanceAware,
IdentifiedDataSerializable {
    private boolean localMember;
    private Address address;
    private String uuid;
    private volatile transient long lastRead = 0L;
    private volatile transient long lastWrite = 0L;
    private volatile transient long lastPing = 0L;
    private volatile transient ILogger logger;

    public MemberImpl() {
    }

    public MemberImpl(Address address, boolean localMember) {
        this(address, localMember, null);
    }

    public MemberImpl(Address address, boolean localMember, String uuid) {
        this();
        this.localMember = localMember;
        this.address = address;
        this.lastRead = Clock.currentTimeMillis();
        this.uuid = uuid;
    }

    public Address getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.address.getPort();
    }

    public InetAddress getInetAddress() {
        try {
            return this.address.getInetAddress();
        }
        catch (UnknownHostException e) {
            if (this.logger != null) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            return null;
        }
    }

    @Override
    public InetSocketAddress getInetSocketAddress() {
        try {
            return this.address.getInetSocketAddress();
        }
        catch (UnknownHostException e) {
            if (this.logger != null) {
                this.logger.log(Level.WARNING, e.getMessage(), e);
            }
            return null;
        }
    }

    @Override
    public boolean localMember() {
        return this.localMember;
    }

    public void didWrite() {
        this.lastWrite = Clock.currentTimeMillis();
    }

    public void didRead() {
        this.lastRead = Clock.currentTimeMillis();
    }

    public void didPing() {
        this.lastPing = Clock.currentTimeMillis();
    }

    public long getLastPing() {
        return this.lastPing;
    }

    public long getLastRead() {
        return this.lastRead;
    }

    public long getLastWrite() {
        return this.lastWrite;
    }

    void setUuid(String uuid) {
        this.uuid = uuid;
    }

    @Override
    public String getUuid() {
        return this.uuid;
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        if (hazelcastInstance instanceof HazelcastInstanceImpl) {
            HazelcastInstanceImpl instance = (HazelcastInstanceImpl)hazelcastInstance;
            this.localMember = instance.node.address.equals(this.address);
            this.logger = instance.node.getLogger(this.getClass().getName());
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.address = new Address();
        this.address.readData(in);
        this.uuid = in.readUTF();
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        this.address.writeData(out);
        out.writeUTF(this.uuid);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Member [");
        sb.append(this.address.getHost());
        sb.append("]");
        sb.append(":");
        sb.append(this.address.getPort());
        if (this.localMember) {
            sb.append(" this");
        }
        return sb.toString();
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberImpl other = (MemberImpl)obj;
        return !(this.address == null ? other.address != null : !this.address.equals(other.address));
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 2;
    }
}

