/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.logging;

import com.hazelcast.instance.Node;
import com.hazelcast.logging.SystemLog;
import com.hazelcast.logging.SystemLogRecord;
import com.hazelcast.logging.SystemObjectLog;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;

public class SystemLogService {
    private final Queue<SystemLog> joinLogs = new LinkedBlockingQueue<SystemLog>(1000);
    private final Queue<SystemLog> connectionLogs = new LinkedBlockingQueue<SystemLog>(1000);
    private final Queue<SystemLog> partitionLogs = new LinkedBlockingQueue<SystemLog>(1000);
    private final Queue<SystemLog> nodeLogs = new LinkedBlockingQueue<SystemLog>(1000);
    private volatile Level currentLevel = Level.DEFAULT;
    private final Node node;
    private final boolean systemLogEnabled;

    public SystemLogService(Node node) {
        this.node = node;
        this.systemLogEnabled = node != null && node.groupProperties.SYSTEM_LOG_ENABLED.getBoolean();
    }

    public String getCurrentLevel() {
        return this.currentLevel.getValue();
    }

    public void setCurrentLevel(String level) {
        this.currentLevel = Level.toLevel(level);
    }

    public List<SystemLogRecord> getLogBundle() {
        ArrayList<SystemLogRecord> systemLogList = new ArrayList<SystemLogRecord>();
        String node = this.node.getThisAddress().getHost() + ":" + this.node.getThisAddress().getPort();
        for (SystemLog log : this.joinLogs) {
            systemLogList.add(new SystemLogRecord(0L, node, log.getDate(), log.toString(), log.getType().toString()));
        }
        for (SystemLog log : this.nodeLogs) {
            systemLogList.add(new SystemLogRecord(0L, node, log.getDate(), log.toString(), log.getType().toString()));
        }
        for (SystemLog log : this.connectionLogs) {
            systemLogList.add(new SystemLogRecord(0L, node, log.getDate(), log.toString(), log.getType().toString()));
        }
        for (SystemLog log : this.partitionLogs) {
            systemLogList.add(new SystemLogRecord(0L, node, log.getDate(), log.toString(), log.getType().toString()));
        }
        return systemLogList;
    }

    public void shutdown() {
        this.connectionLogs.clear();
        this.nodeLogs.clear();
        this.joinLogs.clear();
        this.partitionLogs.clear();
    }

    public String dump() {
        StringBuilder sb = new StringBuilder();
        TreeSet<SystemLog> sorted = new TreeSet<SystemLog>(new Comparator<SystemLog>(){

            @Override
            public int compare(SystemLog o1, SystemLog o2) {
                long thisVal = o1.date;
                long anotherVal = o2.date;
                return thisVal < anotherVal ? -1 : (thisVal == anotherVal ? 0 : 1);
            }
        });
        sorted.addAll(this.joinLogs);
        sorted.addAll(this.nodeLogs);
        sorted.addAll(this.connectionLogs);
        sorted.addAll(this.partitionLogs);
        for (SystemLog systemLog : sorted) {
            sb.append(systemLog.getType().toString());
            sb.append(" - ");
            sb.append(new Date(systemLog.getDate()).toString());
            sb.append(" - ");
            sb.append(systemLog.toString());
            sb.append("\n");
        }
        sb.append(this.node.partitionService.toString());
        sb.append("\n");
        return sb.toString();
    }

    public void logConnection(String str) {
        if (this.systemLogEnabled) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.CONNECTION);
            this.connectionLogs.offer(systemLog);
        }
    }

    public void logPartition(String str) {
        if (this.systemLogEnabled) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.PARTITION);
            this.partitionLogs.offer(systemLog);
        }
    }

    public void logNode(String str) {
        if (this.systemLogEnabled) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.NODE);
            this.nodeLogs.offer(systemLog);
        }
    }

    public void logJoin(String str) {
        if (this.systemLogEnabled) {
            SystemObjectLog systemLog = new SystemObjectLog(str);
            systemLog.setType(SystemLog.Type.JOIN);
            this.joinLogs.offer(systemLog);
        }
    }

    public static enum Level {
        NONE("none"),
        DEFAULT("default"),
        INFO("info"),
        TRACE("trace");

        private String value;

        public String getValue() {
            return this.value;
        }

        private Level(String value) {
            this.value = value;
        }

        public static Level toLevel(String level) {
            if (level.equals("trace")) {
                return TRACE;
            }
            if (level.equals("default")) {
                return DEFAULT;
            }
            if (level.equals("info")) {
                return INFO;
            }
            return NONE;
        }
    }
}

