/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.config.SymmetricEncryptionConfig;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.IOService;
import java.nio.ByteBuffer;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.KeySpec;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

final class CipherHelper {
    private static SymmetricCipherBuilder symmetricCipherBuilder = null;
    static final ILogger logger = Logger.getLogger(CipherHelper.class.getName());

    CipherHelper() {
    }

    public static synchronized Cipher createSymmetricReaderCipher(IOService ioService) throws Exception {
        if (symmetricCipherBuilder == null) {
            symmetricCipherBuilder = new SymmetricCipherBuilder(ioService.getSymmetricEncryptionConfig());
        }
        return symmetricCipherBuilder.getReaderCipher(null);
    }

    public static synchronized Cipher createSymmetricWriterCipher(IOService ioService) throws Exception {
        if (symmetricCipherBuilder == null) {
            symmetricCipherBuilder = new SymmetricCipherBuilder(ioService.getSymmetricEncryptionConfig());
        }
        return symmetricCipherBuilder.getWriterCipher();
    }

    public static boolean isSymmetricEncryptionEnabled(IOService ioService) {
        SymmetricEncryptionConfig sec = ioService.getSymmetricEncryptionConfig();
        return sec != null && sec.isEnabled();
    }

    public static void handleCipherException(Exception e, Connection connection) {
        logger.log(Level.WARNING, e.getMessage(), e);
        connection.close();
    }

    static {
        try {
            if (Boolean.getBoolean("hazelcast.security.bouncy.enabled")) {
                String provider = "org.bouncycastle.jce.provider.BouncyCastleProvider";
                Security.addProvider((Provider)Class.forName(provider).newInstance());
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    static class SymmetricCipherBuilder
    implements CipherBuilder {
        final String algorithm;
        final byte[] salt;
        final String passPhrase;
        final int iterationCount;
        byte[] keyBytes;

        SymmetricCipherBuilder(SymmetricEncryptionConfig sec) {
            this.algorithm = sec.getAlgorithm();
            this.passPhrase = sec.getPassword();
            this.salt = this.createSalt(sec.getSalt());
            this.iterationCount = sec.getIterationCount();
            this.keyBytes = sec.getKey();
        }

        byte[] createSalt(String saltStr) {
            char[] chars;
            long hash = 0L;
            for (char c : chars = saltStr.toCharArray()) {
                hash = 31L * hash + (long)c;
            }
            byte[] theSalt = new byte[]{(byte)(hash >>> 56), (byte)(hash >>> 48), (byte)(hash >>> 40), (byte)(hash >>> 32), (byte)(hash >>> 24), (byte)(hash >>> 16), (byte)(hash >>> 8), (byte)hash};
            return theSalt;
        }

        public Cipher create(boolean encryptMode) {
            try {
                KeySpec keySpec;
                int mode = encryptMode ? 1 : 2;
                Cipher cipher = Cipher.getInstance(this.algorithm);
                String keyAlgorithm = this.algorithm;
                if (this.algorithm.indexOf(47) != -1) {
                    keyAlgorithm = this.algorithm.substring(0, this.algorithm.indexOf(47));
                }
                ByteBuffer bbPass = ByteBuffer.allocate(32);
                MessageDigest md = MessageDigest.getInstance("MD5");
                bbPass.put(md.digest(this.passPhrase.getBytes()));
                md.reset();
                byte[] saltDigest = md.digest(this.salt);
                bbPass.put(saltDigest);
                boolean isCBC = this.algorithm.indexOf("/CBC/") != -1;
                SecretKey key = null;
                int ivLength = 8;
                AlgorithmParameterSpec paramSpec = null;
                if (this.keyBytes == null) {
                    this.keyBytes = bbPass.array();
                }
                if (this.algorithm.startsWith("AES")) {
                    ivLength = 16;
                    key = new SecretKeySpec(this.keyBytes, "AES");
                } else if (this.algorithm.startsWith("Blowfish")) {
                    key = new SecretKeySpec(this.keyBytes, "Blowfish");
                } else if (this.algorithm.startsWith("DESede")) {
                    keySpec = new DESedeKeySpec(this.keyBytes);
                    key = SecretKeyFactory.getInstance("DESede").generateSecret(keySpec);
                } else if (this.algorithm.startsWith("DES")) {
                    keySpec = new DESKeySpec(this.keyBytes);
                    key = SecretKeyFactory.getInstance("DES").generateSecret(keySpec);
                } else if (this.algorithm.startsWith("PBEWith")) {
                    paramSpec = new PBEParameterSpec(this.salt, this.iterationCount);
                    keySpec = new PBEKeySpec(this.passPhrase.toCharArray(), this.salt, this.iterationCount);
                    key = SecretKeyFactory.getInstance(keyAlgorithm).generateSecret(keySpec);
                }
                if (isCBC) {
                    byte[] iv = ivLength == 8 ? this.salt : saltDigest;
                    paramSpec = new IvParameterSpec(iv);
                }
                cipher.init(mode, (Key)key, paramSpec);
                return cipher;
            }
            catch (Throwable e) {
                throw new RuntimeException("unable to create Cipher:" + e.getMessage(), e);
            }
        }

        @Override
        public Cipher getWriterCipher() {
            return this.create(true);
        }

        @Override
        public Cipher getReaderCipher(String ignored) {
            return this.create(false);
        }
    }

    static interface CipherBuilder {
        public Cipher getWriterCipher() throws Exception;

        public Cipher getReaderCipher(String var1) throws Exception;
    }
}

