/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.ClientPacket;
import com.hazelcast.nio.IOService;
import com.hazelcast.nio.SocketReader;
import com.hazelcast.nio.TcpIpConnection;
import java.nio.ByteBuffer;

class SocketClientDataReader
implements SocketReader {
    private ClientPacket packet = null;
    final TcpIpConnection connection;
    final IOService ioService;

    public SocketClientDataReader(TcpIpConnection connection) {
        this.connection = connection;
        this.ioService = connection.getConnectionManager().ioService;
    }

    @Override
    public void read(ByteBuffer inBuffer) throws Exception {
        while (inBuffer.hasRemaining()) {
            boolean complete;
            if (this.packet == null) {
                this.packet = new ClientPacket(this.ioService.getSerializationContext());
            }
            if (!(complete = this.packet.readFrom(inBuffer))) break;
            this.packet.setConn(this.connection);
            this.connection.setType(TcpIpConnection.Type.BINARY_CLIENT);
            this.ioService.handleClientPacket(this.packet);
            this.packet = null;
        }
    }
}

