/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl;

import com.hazelcast.query.impl.QueryException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

final class DateHelper {
    static final String timestampFormat = "yyyy-MM-dd hh:mm:ss.SSS";
    static final String dateFormat = "EEE MMM dd HH:mm:ss zzz yyyy";
    static final String sqlDateFormat = "yyyy-mm-dd";

    static Date parseDate(String value) {
        try {
            return DateHelper.getUtilDateFormat().parse(value);
        }
        catch (ParseException e) {
            return (Date)DateHelper.throwParseException(value, e);
        }
    }

    static Timestamp parseTimeStamp(String value) {
        try {
            return new Timestamp(DateHelper.getTimestampFormat().parse(value).getTime());
        }
        catch (ParseException e) {
            return (Timestamp)DateHelper.throwParseException(value, e);
        }
    }

    static java.sql.Date parseSqlDate(String value) {
        try {
            return new java.sql.Date(DateHelper.getSqlDateFormat().parse(value).getTime());
        }
        catch (ParseException e) {
            return (java.sql.Date)DateHelper.throwParseException(value, e);
        }
    }

    static Date tryParse(String value) {
        try {
            return DateHelper.getUtilDateFormat().parse(value);
        }
        catch (Exception ignored) {
            try {
                return DateHelper.getTimestampFormat().parse(value);
            }
            catch (Exception ignored2) {
                try {
                    return DateHelper.getSqlDateFormat().parse(value);
                }
                catch (Exception exception) {
                    return (Date)DateHelper.throwParseException(value, null);
                }
            }
        }
    }

    private static <T> T throwParseException(String value, Exception e) {
        throw new QueryException("Unable to parse date from value: '" + value + "' ! Valid formats are: '" + dateFormat + "', '" + timestampFormat + "' and '" + sqlDateFormat + "'.", e);
    }

    private static DateFormat getTimestampFormat() {
        return new SimpleDateFormat(timestampFormat);
    }

    private static DateFormat getSqlDateFormat() {
        return new SimpleDateFormat(sqlDateFormat);
    }

    private static DateFormat getUtilDateFormat() {
        return new SimpleDateFormat(dateFormat);
    }

    private DateHelper() {
    }
}

