/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.client;

import com.hazelcast.client.PartitionClientRequest;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.queue.QueuePortableHook;
import java.io.IOException;

public abstract class QueueRequest
extends PartitionClientRequest
implements Portable {
    protected String name;
    protected long timeoutMillis;

    protected QueueRequest() {
    }

    protected QueueRequest(String name) {
        this.name = name;
    }

    protected QueueRequest(String name, long timeoutMillis) {
        this.name = name;
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    protected int getPartition() {
        return this.getClientEngine().getPartitionService().getPartitionId(this.name);
    }

    @Override
    protected int getReplicaIndex() {
        return 0;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:queueService";
    }

    @Override
    public int getFactoryId() {
        return QueuePortableHook.F_ID;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeLong("t", this.timeoutMillis);
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.timeoutMillis = reader.readLong("t");
    }
}

