/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.map.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.query.impl.QueryResultEntry;
import com.hazelcast.query.impl.QueryResultEntryImpl;
import com.hazelcast.util.IterationType;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class QueryDataResultStream
extends AbstractSet
implements IdentifiedDataSerializable {
    private static final QueryResultEntry END = new QueryResultEntryImpl(null, null, null);
    private final BlockingQueue<QueryResultEntry> q = new LinkedBlockingQueue<QueryResultEntry>();
    private final Object endLock = new Object();
    private boolean ended = false;
    private boolean set;
    private Set<Object> keys;
    private IterationType iterationType;
    private volatile boolean started = false;
    private volatile int size = 0;

    public QueryDataResultStream() {
    }

    public QueryDataResultStream(IterationType iterationType) {
        this(iterationType, iterationType != IterationType.VALUE);
    }

    public QueryDataResultStream(IterationType iterationType, boolean set) {
        this.set = set;
        this.iterationType = iterationType;
        this.keys = set ? new HashSet<Object>() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        this.q.offer(END);
        Object object = this.endLock;
        synchronized (object) {
            this.ended = true;
        }
    }

    @Override
    public synchronized boolean add(Object obj) {
        if (!this.started) {
            this.started = true;
        }
        QueryResultEntry entry = (QueryResultEntry)obj;
        if (!this.set || this.keys.add(entry.getIndexKey())) {
            this.q.offer(entry);
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new It();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (!this.started) {
            return 0;
        }
        Object object = this.endLock;
        synchronized (object) {
            while (!this.ended) {
                try {
                    this.endLock.wait();
                }
                catch (InterruptedException e) {
                    return this.size;
                }
            }
            return this.size;
        }
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 13;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.set);
        out.writeUTF(this.iterationType.name());
        out.writeInt(this.size);
        for (QueryResultEntry queryResultEntry : this.q) {
            out.writeObject(queryResultEntry);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.set = in.readBoolean();
        this.iterationType = IterationType.valueOf(in.readUTF());
        this.size = in.readInt();
        for (int i = 0; i < this.size; ++i) {
            this.q.add((QueryResultEntry)in.readObject());
        }
        this.started = true;
    }

    class It
    implements Iterator {
        QueryResultEntry currentEntry;

        It() {
        }

        @Override
        public boolean hasNext() {
            QueryResultEntry entry;
            try {
                entry = (QueryResultEntry)QueryDataResultStream.this.q.peek();
            }
            catch (Exception e) {
                return false;
            }
            return entry != END && entry != null;
        }

        public Object next() {
            this.currentEntry = (QueryResultEntry)QueryDataResultStream.this.q.poll();
            if (this.currentEntry == null || this.currentEntry == END) {
                return null;
            }
            if (QueryDataResultStream.this.iterationType == IterationType.VALUE) {
                Data valueData = this.currentEntry.getValueData();
                return valueData;
            }
            if (QueryDataResultStream.this.iterationType == IterationType.KEY) {
                Data keyData = this.currentEntry.getKeyData();
                return keyData;
            }
            Data keyData = this.currentEntry.getKeyData();
            Data valueData = this.currentEntry.getValueData();
            return new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, valueData);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

