/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.query.impl.QueryResultEntry;
import com.hazelcast.query.impl.QueryResultEntryImpl;
import com.hazelcast.util.IterationType;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class QueryResultStream
extends AbstractSet<QueryResultEntry> {
    private final BlockingQueue<QueryResultEntry> q = new LinkedBlockingQueue<QueryResultEntry>();
    private boolean ended = false;
    private final Object endLock = new Object();
    private static final QueryResultEntry END = new QueryResultEntryImpl(null, null, null);
    private final SerializationService serializationService;
    private final boolean set;
    private final Set<Object> keys;
    private final boolean data;
    private final IterationType iterationType;
    private volatile boolean started = false;
    private volatile int size = 0;

    public QueryResultStream(SerializationService serializationService, IterationType iterationType, boolean data) {
        this(serializationService, iterationType, data, iterationType != IterationType.VALUE);
    }

    public QueryResultStream(SerializationService serializationService, IterationType iterationType, boolean data, boolean set) {
        this.serializationService = serializationService;
        this.set = set;
        this.data = data;
        this.iterationType = iterationType;
        this.keys = set ? new HashSet<Object>() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        this.q.offer(END);
        Object object = this.endLock;
        synchronized (object) {
            this.ended = true;
        }
    }

    @Override
    public synchronized boolean add(QueryResultEntry entry) {
        if (!this.started) {
            this.started = true;
        }
        if (!this.set || this.keys.add(entry.getIndexKey())) {
            this.q.offer(entry);
            ++this.size;
            return true;
        }
        return false;
    }

    @Override
    public Iterator iterator() {
        return new It();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if (!this.started) {
            return 0;
        }
        Object object = this.endLock;
        synchronized (object) {
            while (!this.ended) {
                try {
                    this.endLock.wait();
                }
                catch (InterruptedException e) {
                    return this.size;
                }
            }
            return this.size;
        }
    }

    class It
    implements Iterator {
        QueryResultEntry currentEntry;

        It() {
        }

        @Override
        public boolean hasNext() {
            QueryResultEntry entry;
            try {
                entry = (QueryResultEntry)QueryResultStream.this.q.peek();
            }
            catch (Exception e) {
                return false;
            }
            return entry != END && entry != null;
        }

        public Object next() {
            this.currentEntry = (QueryResultEntry)QueryResultStream.this.q.poll();
            if (this.currentEntry == null || this.currentEntry == END) {
                return null;
            }
            if (QueryResultStream.this.iterationType == IterationType.VALUE) {
                Data valueData = this.currentEntry.getValueData();
                return QueryResultStream.this.data ? valueData : QueryResultStream.this.serializationService.toObject(valueData);
            }
            if (QueryResultStream.this.iterationType == IterationType.KEY) {
                Data keyData = this.currentEntry.getKeyData();
                return QueryResultStream.this.data ? keyData : QueryResultStream.this.serializationService.toObject(keyData);
            }
            Data keyData = this.currentEntry.getKeyData();
            Data valueData = this.currentEntry.getValueData();
            return QueryResultStream.this.data ? new AbstractMap.SimpleImmutableEntry<Data, Data>(keyData, valueData) : new AbstractMap.SimpleImmutableEntry<Object, Object>(QueryResultStream.this.serializationService.toObject(keyData), QueryResultStream.this.serializationService.toObject(valueData));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

