/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.IOUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class ServiceLoader {
    private static final ILogger logger = Logger.getLogger(ServiceLoader.class.getName());

    public static <T> T load(Class<T> clazz, String factoryId, ClassLoader classLoader) throws Exception {
        Iterator<T> iter = ServiceLoader.iterator(clazz, factoryId, classLoader);
        if (iter.hasNext()) {
            return iter.next();
        }
        return null;
    }

    public static <T> Iterator<T> iterator(final Class<T> clazz, String factoryId, final ClassLoader classLoader) throws Exception {
        final Set<String> classNames = ServiceLoader.parse(factoryId, classLoader);
        return new Iterator<T>(){
            final Iterator<String> classIter;
            {
                this.classIter = classNames.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.classIter.hasNext();
            }

            @Override
            public T next() {
                String className = this.classIter.next();
                try {
                    return clazz.cast(ClassLoaderUtil.newInstance(classLoader, className));
                }
                catch (Exception e) {
                    throw new HazelcastException(e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> parse(String factoryId, ClassLoader classLoader) {
        ClassLoader cl = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        String resourceName = "META-INF/services/" + factoryId;
        try {
            Enumeration<URL> configs = cl != null ? cl.getResources(resourceName) : ClassLoader.getSystemResources(resourceName);
            HashSet<String> names = new HashSet<String>();
            while (configs.hasMoreElements()) {
                URL url = configs.nextElement();
                BufferedReader r = null;
                try {
                    String line;
                    r = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));
                    while ((line = r.readLine()) != null) {
                        String name;
                        int comment = line.indexOf(35);
                        if (comment >= 0) {
                            line = line.substring(0, comment);
                        }
                        if ((name = line.trim()).length() == 0) continue;
                        names.add(name);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeResource(r);
                    throw throwable;
                }
                IOUtil.closeResource(r);
            }
            return names;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return Collections.emptySet();
        }
    }
}

