/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.wan;

import com.hazelcast.cluster.AuthorizationOperation;
import com.hazelcast.instance.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.Packet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.AddressUtil;
import com.hazelcast.wan.ReplicationEventObject;
import com.hazelcast.wan.WanReplicationEndpoint;
import com.hazelcast.wan.WanReplicationEvent;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Level;

public class WanNoDelayReplication
implements Runnable,
WanReplicationEndpoint {
    private Node node;
    private ILogger logger;
    private String groupName;
    private String password;
    private final LinkedBlockingQueue<String> addressQueue = new LinkedBlockingQueue();
    private final LinkedList<WanReplicationEvent> failureQ = new LinkedList();
    private final BlockingQueue<WanReplicationEvent> q = new ArrayBlockingQueue<WanReplicationEvent>(100000);
    private volatile boolean running = true;

    @Override
    public void init(Node node, String groupName, String password, String ... targets) {
        this.node = node;
        this.logger = node.getLogger(WanNoDelayReplication.class.getName());
        this.groupName = groupName;
        this.password = password;
        this.addressQueue.addAll(Arrays.asList(targets));
        node.nodeEngine.getExecutionService().execute("hz:wan", this);
    }

    @Override
    public void publishReplicationEvent(String serviceName, ReplicationEventObject eventObject) {
        WanReplicationEvent replicationEvent = new WanReplicationEvent(serviceName, eventObject);
        if (!this.q.offer(replicationEvent)) {
            this.q.poll();
            this.q.offer(replicationEvent);
        }
    }

    @Override
    public void shutdown() {
        this.running = false;
    }

    @Override
    public void run() {
        Connection conn = null;
        while (this.running) {
            try {
                boolean authorized;
                WanReplicationEvent event;
                WanReplicationEvent wanReplicationEvent = event = this.failureQ.size() > 0 ? this.failureQ.removeFirst() : this.q.take();
                if (conn == null && (conn = this.getConnection()) != null && !(authorized = this.checkAuthorization(this.groupName, this.password, conn.getEndPoint()))) {
                    conn.close();
                    conn = null;
                    if (this.logger != null) {
                        this.logger.log(Level.SEVERE, "Invalid groupName or groupPassword! ");
                    }
                }
                if (conn != null && conn.live()) {
                    Data data = this.node.nodeEngine.getSerializationService().toData(event);
                    Packet packet = new Packet(data, this.node.nodeEngine.getSerializationContext());
                    packet.setHeader(3);
                    this.node.nodeEngine.send(packet, conn);
                    continue;
                }
                this.failureQ.addFirst(event);
                conn = null;
            }
            catch (InterruptedException e) {
                this.running = false;
            }
            catch (Throwable e) {
                if (this.logger != null) {
                    this.logger.log(Level.WARNING, e.getMessage(), e);
                }
                conn = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection getConnection() throws InterruptedException {
        int defaultPort = this.node.getConfig().getNetworkConfig().getPort();
        while (this.running) {
            String targetStr = this.addressQueue.take();
            try {
                AddressUtil.AddressHolder addressHolder = AddressUtil.getAddressHolder(targetStr, defaultPort);
                Address target = new Address(addressHolder.address, addressHolder.port);
                ConnectionManager connectionManager = this.node.getConnectionManager();
                Connection conn = connectionManager.getOrConnect(target);
                for (int i = 0; i < 10; ++i) {
                    if (conn != null) {
                        Connection connection = conn;
                        return connection;
                    }
                    Thread.sleep(1000L);
                    conn = connectionManager.getConnection(target);
                }
            }
            catch (Throwable e) {
                Thread.sleep(1000L);
            }
            finally {
                this.addressQueue.offer(targetStr);
            }
        }
        return null;
    }

    public boolean checkAuthorization(String groupName, String groupPassword, Address target) {
        AuthorizationOperation authorizationCall = new AuthorizationOperation(groupName, groupPassword);
        Future future = this.node.nodeEngine.getOperationService().createInvocationBuilder("hz:core:wanReplicationService", (Operation)authorizationCall, target).setTryCount(1).build().invoke();
        try {
            return (Boolean)future.get();
        }
        catch (Exception ignored) {
            return false;
        }
    }
}

