/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ascii.memcache;

import com.hazelcast.ascii.TextCommandService;
import com.hazelcast.ascii.memcache.GetCommand;
import com.hazelcast.ascii.memcache.MemcacheCommandProcessor;
import com.hazelcast.ascii.memcache.MemcacheEntry;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.logging.ILogger;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.logging.Level;

public class GetCommandProcessor
extends MemcacheCommandProcessor<GetCommand> {
    final boolean single;
    private final ILogger logger;

    public GetCommandProcessor(TextCommandService textCommandService, boolean single) {
        super(textCommandService);
        this.single = single;
        this.logger = textCommandService.getNode().getLogger(this.getClass().getName());
    }

    @Override
    public void handle(GetCommand getCommand) {
        String key = null;
        try {
            key = URLDecoder.decode(getCommand.getKey(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new HazelcastException(e);
        }
        String mapName = "hz_memcache_default";
        int index = key.indexOf(58);
        if (index != -1) {
            mapName = "hz_memcache_" + key.substring(0, index);
            key = key.substring(index + 1);
        }
        Object value = this.textCommandService.get(mapName, key);
        MemcacheEntry entry = null;
        if (value != null) {
            if (value instanceof MemcacheEntry) {
                entry = (MemcacheEntry)value;
            } else if (value instanceof byte[]) {
                entry = new MemcacheEntry(getCommand.getKey(), (byte[])value, 0);
            } else if (value instanceof String) {
                entry = new MemcacheEntry(getCommand.getKey(), ((String)value).getBytes(), 0);
            } else {
                try {
                    entry = new MemcacheEntry(getCommand.getKey(), this.textCommandService.toByteArray(value), 0);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }
        if (entry != null) {
            this.textCommandService.incrementGetHitCount();
        } else {
            this.textCommandService.incrementGetMissCount();
        }
        getCommand.setValue(entry, this.single);
        this.textCommandService.sendResponse(getCommand);
    }

    @Override
    public void handleRejection(GetCommand getCommand) {
        getCommand.setValue(null, this.single);
        this.textCommandService.sendResponse(getCommand);
    }
}

