/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.nearcache;

import com.hazelcast.config.MapConfig;
import com.hazelcast.util.Clock;
import java.util.concurrent.atomic.AtomicInteger;

public class CacheRecord
implements Comparable<CacheRecord> {
    final Object key;
    final Object value;
    volatile long lastAccessTime;
    final long creationTime;
    final AtomicInteger hit;
    private MapConfig.EvictionPolicy evictionPolicy;
    private int maxIdleMillis;
    private int timeToLiveMillis;

    CacheRecord(Object key, Object value, MapConfig.EvictionPolicy evictionPolicy, int maxIdleMillis, int timeToLiveMillis) {
        long time;
        this.key = key;
        this.value = value;
        this.lastAccessTime = time = Clock.currentTimeMillis();
        this.creationTime = time;
        this.hit = new AtomicInteger(0);
        this.evictionPolicy = evictionPolicy;
        this.maxIdleMillis = maxIdleMillis;
        this.timeToLiveMillis = timeToLiveMillis;
    }

    void access() {
        this.hit.incrementAndGet();
        this.lastAccessTime = Clock.currentTimeMillis();
    }

    boolean expired() {
        long time = Clock.currentTimeMillis();
        return this.maxIdleMillis > 0 && time > this.lastAccessTime + (long)this.maxIdleMillis || this.timeToLiveMillis > 0 && time > this.creationTime + (long)this.timeToLiveMillis;
    }

    @Override
    public int compareTo(CacheRecord o) {
        if (MapConfig.EvictionPolicy.LRU.equals((Object)this.evictionPolicy)) {
            return Long.valueOf(this.lastAccessTime).compareTo(o.lastAccessTime);
        }
        if (MapConfig.EvictionPolicy.LFU.equals((Object)this.evictionPolicy)) {
            return Integer.valueOf(this.hit.get()).compareTo(o.hit.get());
        }
        return 0;
    }
}

