/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster;

import com.hazelcast.cluster.JoinMessage;
import com.hazelcast.cluster.MulticastListener;
import com.hazelcast.config.Config;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class MulticastService
implements Runnable {
    private static final int DATAGRAM_BUFFER_SIZE = 65536;
    private final ILogger logger;
    private final MulticastSocket multicastSocket;
    private final DatagramPacket datagramPacketSend;
    private final DatagramPacket datagramPacketReceive;
    private final Object sendLock = new Object();
    private final CountDownLatch stopLatch = new CountDownLatch(1);
    private final List<MulticastListener> listeners = new CopyOnWriteArrayList<MulticastListener>();
    private final Node node;
    private final BufferObjectDataOutput sendOutput;
    private volatile boolean running = true;

    public MulticastService(Node node, MulticastSocket multicastSocket) throws Exception {
        this.node = node;
        this.logger = node.getLogger(MulticastService.class.getName());
        Config config = node.getConfig();
        this.multicastSocket = multicastSocket;
        this.sendOutput = node.getSerializationService().createObjectDataOutput(1024);
        this.datagramPacketReceive = new DatagramPacket(new byte[65536], 65536);
        MulticastConfig multicastConfig = config.getNetworkConfig().getJoin().getMulticastConfig();
        this.datagramPacketSend = new DatagramPacket(new byte[0], 0, InetAddress.getByName(multicastConfig.getMulticastGroup()), multicastConfig.getMulticastPort());
        this.running = true;
    }

    public void addMulticastListener(MulticastListener multicastListener) {
        this.listeners.add(multicastListener);
    }

    public void removeMulticastListener(MulticastListener multicastListener) {
        this.listeners.remove(multicastListener);
    }

    public void stop() {
        try {
            if (!this.running && this.multicastSocket.isClosed()) {
                return;
            }
            try {
                this.multicastSocket.close();
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            this.running = false;
            if (!this.stopLatch.await(5L, TimeUnit.SECONDS)) {
                this.logger.log(Level.WARNING, "Failed to shutdown MulticastService in 5 seconds!");
            }
        }
        catch (Throwable e) {
            this.logger.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private void cleanup() {
        this.running = false;
        try {
            this.sendOutput.close();
            this.datagramPacketReceive.setData(new byte[0]);
            this.datagramPacketSend.setData(new byte[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.stopLatch.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (this.running) {
                try {
                    JoinMessage joinMessage = this.receive();
                    if (joinMessage == null) continue;
                    for (MulticastListener multicastListener : this.listeners) {
                        try {
                            multicastListener.onMessage(joinMessage);
                        }
                        catch (Exception e) {
                            this.logger.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                catch (OutOfMemoryError e) {
                    OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return;
        }
        finally {
            this.cleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - bad return control flow
     */
    private JoinMessage receive() {
        JoinMessage joinMessage;
        try {
            this.multicastSocket.receive(this.datagramPacketReceive);
        }
        catch (IOException ignore) {
            return null;
        }
        byte[] data = this.datagramPacketReceive.getData();
        int offset = this.datagramPacketReceive.getOffset();
        int length = this.datagramPacketReceive.getLength();
        BufferObjectDataInput input = this.node.getSerializationService().createObjectDataInput(data);
        input.position(offset);
        byte packetVersion = input.readByte();
        if (packetVersion != 1) {
            this.logger.log(Level.WARNING, "Received a JoinRequest with different packet version: " + packetVersion);
            return null;
        }
        try {
            joinMessage = (JoinMessage)input.readObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                    throw throwable;
                }
                catch (Exception e) {
                    if (!(e instanceof EOFException)) {
                        throw e;
                    }
                    this.logger.log(Level.WARNING, "Received data format is invalid. (An old version of Hazelcast may be running here.)", e);
                }
            }
            catch (Exception e2) {
                this.logger.log(Level.WARNING, e2.getMessage(), e2);
            }
        }
        input.close();
        return joinMessage;
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(JoinMessage joinMessage) {
        if (!this.running) {
            return;
        }
        BufferObjectDataOutput out = this.sendOutput;
        Object object = this.sendLock;
        synchronized (object) {
            try {
                out.writeByte(1);
                out.writeObject(joinMessage);
                this.datagramPacketSend.setData(out.toByteArray());
                this.multicastSocket.send(this.datagramPacketSend);
                out.clear();
            }
            catch (IOException e) {
                this.logger.log(Level.WARNING, "You probably have too long Hazelcast configuration!", e);
            }
        }
    }
}

