/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.client;

import com.hazelcast.client.CallableClientRequest;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.ClientEngine;
import com.hazelcast.cluster.ClusterServiceImpl;
import com.hazelcast.cluster.client.ClientMembershipEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.spi.impl.SerializableCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;

public final class AddMembershipListenerRequest
extends CallableClientRequest
implements IdentifiedDataSerializable {
    public Object call() throws Exception {
        ClusterServiceImpl service = (ClusterServiceImpl)this.getService();
        final ClientEndpoint endpoint = this.getEndpoint();
        final ClientEngine clientEngine = this.getClientEngine();
        String registration = service.addMembershipListener(new MembershipListener(){

            @Override
            public void memberAdded(MembershipEvent membershipEvent) {
                if (endpoint.live()) {
                    MemberImpl member = (MemberImpl)membershipEvent.getMember();
                    clientEngine.sendResponse(endpoint, new ClientMembershipEvent(member, 1));
                }
            }

            @Override
            public void memberRemoved(MembershipEvent membershipEvent) {
                if (endpoint.live()) {
                    MemberImpl member = (MemberImpl)membershipEvent.getMember();
                    clientEngine.sendResponse(endpoint, new ClientMembershipEvent(member, 3));
                }
            }
        });
        String name = "hz:core:clusterService";
        endpoint.setListenerRegistration("hz:core:clusterService", "hz:core:clusterService", registration);
        Collection<MemberImpl> memberList = service.getMemberList();
        ArrayList<Data> response = new ArrayList<Data>(memberList.size());
        SerializationService serializationService = this.getClientEngine().getSerializationService();
        for (MemberImpl member : memberList) {
            response.add(serializationService.toData(member));
        }
        return new SerializableCollection(response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:clusterService";
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getId() {
        return 7;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
    }
}

