/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.set.tx;

import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.CollectionService;
import com.hazelcast.collection.multimap.tx.TransactionalMultiMapProxySupport;
import com.hazelcast.config.MultiMapConfig;
import com.hazelcast.core.TransactionalSet;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.transaction.impl.TransactionSupport;

public class TransactionalSetProxy<E>
extends TransactionalMultiMapProxySupport
implements TransactionalSet<E> {
    final Data key;

    public TransactionalSetProxy(NodeEngine nodeEngine, CollectionService service, CollectionProxyId proxyId, TransactionSupport tx) {
        super(nodeEngine, service, proxyId, tx, nodeEngine.getConfig().getMultiMapConfig("set:" + proxyId.getKeyName()).setValueCollectionType(MultiMapConfig.ValueCollectionType.SET));
        this.key = nodeEngine.toData(proxyId.getKeyName());
    }

    @Override
    public boolean add(E e) {
        Data value = this.getNodeEngine().toData(e);
        return this.putInternal(this.key, value);
    }

    @Override
    public boolean remove(E e) {
        Data value = this.getNodeEngine().toData(e);
        return this.removeInternal(this.key, value);
    }

    @Override
    public int size() {
        return this.valueCountInternal(this.key);
    }
}

