/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.concurrent.lock;

import com.hazelcast.concurrent.lock.UnlockOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.Invocation;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.ObjectNamespace;
import com.hazelcast.spi.Operation;
import com.hazelcast.util.scheduler.EntryTaskScheduler;
import com.hazelcast.util.scheduler.ScheduledEntry;
import com.hazelcast.util.scheduler.ScheduledEntryProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class LockEvictionProcessor
implements ScheduledEntryProcessor<Data, Object> {
    final NodeEngine nodeEngine;
    final ObjectNamespace namespace;

    public LockEvictionProcessor(NodeEngine nodeEngine, ObjectNamespace namespace) {
        this.nodeEngine = nodeEngine;
        this.namespace = namespace;
    }

    @Override
    public void process(EntryTaskScheduler<Data, Object> scheduler, Collection<ScheduledEntry<Data, Object>> entries) {
        ArrayList<Future> futures = new ArrayList<Future>(entries.size());
        ILogger logger = this.nodeEngine.getLogger(this.getClass());
        for (ScheduledEntry<Data, Object> entry : entries) {
            Data key = entry.getKey();
            UnlockOperation operation = new UnlockOperation(this.namespace, key, -1, true);
            int partitionId = this.nodeEngine.getPartitionService().getPartitionId(key);
            try {
                Invocation invocation = this.nodeEngine.getOperationService().createInvocationBuilder("hz:impl:lockService", (Operation)operation, partitionId).build();
                Future f = invocation.invoke();
                futures.add(f);
            }
            catch (Throwable t) {
                logger.log(Level.WARNING, t.getMessage(), t);
            }
        }
        for (Future future : futures) {
            try {
                future.get(30L, TimeUnit.SECONDS);
            }
            catch (TimeoutException e) {
                logger.log(Level.FINEST, e.getMessage(), e);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }
}

