/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.hibernate.instance;

import com.hazelcast.config.Config;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.DuplicateInstanceNameException;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.hibernate.CacheEnvironment;
import com.hazelcast.hibernate.instance.HazelcastInstanceFactory;
import com.hazelcast.hibernate.instance.IHazelcastInstanceLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import org.hibernate.cache.CacheException;

class HazelcastInstanceLoader
implements IHazelcastInstanceLoader {
    private static final ILogger logger = Logger.getLogger(HazelcastInstanceFactory.class);
    private final Properties props = new Properties();
    private String instanceName = null;
    private HazelcastInstance instance;
    private Config config = null;

    HazelcastInstanceLoader() {
    }

    @Override
    public void configure(Properties props) {
        this.props.putAll((Map<?, ?>)props);
    }

    @Override
    public HazelcastInstance loadInstance() throws CacheException {
        if (this.instance != null && this.instance.getLifecycleService().isRunning()) {
            logger.log(Level.WARNING, "Current HazelcastInstance is already loaded and running! Returning current instance...");
            return this.instance;
        }
        String configResourcePath = null;
        this.instanceName = CacheEnvironment.getInstanceName(this.props);
        configResourcePath = CacheEnvironment.getConfigFilePath(this.props);
        if (!HazelcastInstanceLoader.isEmpty(configResourcePath)) {
            try {
                this.config = ConfigLoader.load(configResourcePath);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "IOException: " + e.getMessage());
            }
            if (this.config == null) {
                throw new CacheException("Could not find configuration file: " + configResourcePath);
            }
        }
        if (this.instanceName != null) {
            this.instance = Hazelcast.getHazelcastInstanceByName(this.instanceName);
            if (this.instance == null) {
                try {
                    this.createOrGetInstance();
                }
                catch (DuplicateInstanceNameException ignored) {
                    this.instance = Hazelcast.getHazelcastInstanceByName(this.instanceName);
                }
            }
        } else {
            this.createOrGetInstance();
        }
        return this.instance;
    }

    private void createOrGetInstance() throws DuplicateInstanceNameException {
        if (this.config == null) {
            this.config = new XmlConfigBuilder().build();
        }
        this.config.setInstanceName(this.instanceName);
        this.instance = Hazelcast.newHazelcastInstance(this.config);
    }

    @Override
    public void unloadInstance() throws CacheException {
        if (this.instance == null) {
            return;
        }
        boolean shutDown = CacheEnvironment.shutdownOnStop(this.props, this.instanceName == null);
        if (!shutDown) {
            logger.log(Level.WARNING, "hibernate.cache.hazelcast.shutdown_on_session_factory_close property is set to 'false'. Leaving current HazelcastInstance active! (Warning: Do not disable Hazelcast hazelcast.shutdownhook.enabled property!)");
            return;
        }
        try {
            this.instance.getLifecycleService().shutdown();
            this.instance = null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }
}

