/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.IList;
import com.hazelcast.core.ItemEvent;
import com.hazelcast.core.ItemListener;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;

@ManagedDescription(value="IList")
public class ListMBean
extends HazelcastMBean<IList<?>> {
    private long totalAddedItemCount;
    private long totalRemovedItemCount;
    private final String registrationId;

    protected ListMBean(IList<?> managedObject, ManagementService service) {
        super(managedObject, service);
        this.objectName = this.createObjectName("List", managedObject.getName());
        ItemListener itemListener = new ItemListener(){

            public void itemAdded(ItemEvent item) {
                ListMBean.this.totalAddedItemCount++;
            }

            public void itemRemoved(ItemEvent item) {
                ListMBean.this.totalRemovedItemCount++;
            }
        };
        this.registrationId = managedObject.addItemListener(itemListener, false);
    }

    @ManagedAnnotation(value="clear", operation=true)
    @ManagedDescription(value="Clear List")
    public void clear() {
        ((IList)this.managedObject).clear();
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the DistributedObject")
    public String getName() {
        return ((IList)this.managedObject).getName();
    }

    @ManagedAnnotation(value="totalAddedItemCount")
    public long getTotalAddedItemCount() {
        return this.totalAddedItemCount;
    }

    @ManagedAnnotation(value="totalRemovedItemCount")
    public long getTotalRemovedItemCount() {
        return this.totalRemovedItemCount;
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
        ((IList)this.managedObject).removeItemListener(this.registrationId);
    }
}

