/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.operation.LockAwareOperation;
import com.hazelcast.map.operation.PutBackupOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupAwareOperation;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ResponseHandler;

public abstract class BasePutOperation
extends LockAwareOperation
implements BackupAwareOperation {
    protected transient Data dataOldValue;

    public BasePutOperation(String name, Data dataKey, Data value) {
        super(name, dataKey, value, -1L);
    }

    public BasePutOperation(String name, Data dataKey, Data value, long ttl) {
        super(name, dataKey, value, ttl);
    }

    public BasePutOperation() {
    }

    @Override
    public void afterRun() {
        this.mapService.interceptAfterPut(this.name, this.dataValue);
        EntryEventType eventType = this.dataOldValue == null ? EntryEventType.ADDED : EntryEventType.UPDATED;
        this.mapService.publishEvent(this.getCallerAddress(), this.name, eventType, this.dataKey, this.dataOldValue, this.dataValue);
        this.invalidateNearCaches();
        if (this.mapContainer.getWanReplicationPublisher() != null && this.mapContainer.getWanMergePolicy() != null) {
            SimpleEntryView<Data, Data> entryView = new SimpleEntryView<Data, Data>(this.dataKey, this.mapService.toData(this.dataValue), this.recordStore.getRecords().get(this.dataKey));
            this.mapService.publishWanReplicationUpdate(this.name, entryView);
        }
    }

    @Override
    public boolean shouldBackup() {
        return true;
    }

    @Override
    public Operation getBackupOperation() {
        return new PutBackupOperation(this.name, this.dataKey, this.dataValue, this.ttl);
    }

    @Override
    public final int getAsyncBackupCount() {
        return this.mapContainer.getAsyncBackupCount();
    }

    @Override
    public final int getSyncBackupCount() {
        return this.mapContainer.getBackupCount();
    }

    @Override
    public void onWaitExpire() {
        ResponseHandler responseHandler = this.getResponseHandler();
        responseHandler.sendResponse(null);
    }

    public String toString() {
        return "BasePutOperation{" + this.name + "}";
    }
}

