/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.MapService;
import com.hazelcast.map.RecordStore;
import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class EntryBackupOperation
extends KeyBasedMapOperation
implements BackupOperation {
    EntryBackupProcessor entryProcessor;
    Map.Entry entry;
    MapService mapService;

    public EntryBackupOperation(String name, Data dataKey, EntryBackupProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    public EntryBackupOperation() {
    }

    @Override
    public void run() {
        this.mapService = (MapService)this.getService();
        RecordStore recordStore = this.mapService.getRecordStore(this.getPartitionId(), this.name);
        Map.Entry<Data, Object> mapEntry = recordStore.getMapEntryObject(this.dataKey);
        this.entry = new AbstractMap.SimpleEntry<Object, Object>(this.mapService.toObject(this.dataKey), mapEntry.getValue());
        this.entryProcessor.processBackup(this.entry);
        recordStore.put(new AbstractMap.SimpleImmutableEntry<Data, Object>(this.dataKey, this.entry.getValue()));
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryBackupProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public Object getResponse() {
        return true;
    }

    public String toString() {
        return "EntryBackupOperation{}";
    }
}

