/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.config.GlobalSerializerConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SerializerConfig;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.nio.serialization.ByteArrayInputOutputFactory;
import com.hazelcast.nio.serialization.ByteBufferInputOutputFactory;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.InputOutputFactory;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.serialization.SerializationServiceImpl;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.UnsafeInputOutputFactory;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class SerializationServiceBuilder {
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
    private SerializationConfig config;
    private int version = -1;
    private final Map<Integer, DataSerializableFactory> dataSerializableFactories = new HashMap<Integer, DataSerializableFactory>();
    private final Map<Integer, PortableFactory> portableFactories = new HashMap<Integer, PortableFactory>();
    private boolean checkClassDefErrors = true;
    private final Set<ClassDefinition> classDefinitions = new HashSet<ClassDefinition>();
    private ManagedContext managedContext;
    private boolean useNativeByteOrder = false;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private boolean enableCompression = false;
    private boolean enableSharedObject = false;
    private boolean allowUnsafe = false;

    public SerializationServiceBuilder setVersion(int version) {
        if (version < 0) {
            throw new IllegalArgumentException("Version cannot be negative!");
        }
        this.version = version;
        return this;
    }

    public SerializationServiceBuilder setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public SerializationServiceBuilder setConfig(SerializationConfig config) {
        this.config = config;
        if (this.version < 0) {
            this.version = config.getPortableVersion();
        }
        this.checkClassDefErrors = config.isCheckClassDefErrors();
        this.useNativeByteOrder = config.isUseNativeByteOrder();
        this.byteOrder = config.getByteOrder();
        this.enableCompression = config.isEnableCompression();
        this.enableSharedObject = config.isEnableSharedObject();
        this.allowUnsafe = config.isAllowUnsafe();
        return this;
    }

    public SerializationServiceBuilder addDataSerializableFactory(int id, DataSerializableFactory factory) {
        this.dataSerializableFactories.put(id, factory);
        return this;
    }

    public SerializationServiceBuilder addPortableFactory(int id, PortableFactory factory) {
        this.portableFactories.put(id, factory);
        return this;
    }

    public SerializationServiceBuilder addClassDefinition(ClassDefinition cd) {
        this.classDefinitions.add(cd);
        return this;
    }

    public SerializationServiceBuilder setCheckClassDefErrors(boolean checkClassDefErrors) {
        this.checkClassDefErrors = checkClassDefErrors;
        return this;
    }

    public SerializationServiceBuilder setManagedContext(ManagedContext managedContext) {
        this.managedContext = managedContext;
        return this;
    }

    public SerializationServiceBuilder setUseNativeByteOrder(boolean useNativeByteOrder) {
        this.useNativeByteOrder = useNativeByteOrder;
        return this;
    }

    public SerializationServiceBuilder setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
        return this;
    }

    public SerializationServiceBuilder setEnableCompression(boolean enableCompression) {
        this.enableCompression = enableCompression;
        return this;
    }

    public SerializationServiceBuilder setEnableSharedObject(boolean enableSharedObject) {
        this.enableSharedObject = enableSharedObject;
        return this;
    }

    public SerializationServiceBuilder setAllowUnsafe(boolean allowUnsafe) {
        this.allowUnsafe = allowUnsafe;
        return this;
    }

    public SerializationService build() {
        if (this.version < 0) {
            this.version = 0;
        }
        if (this.config != null) {
            SerializationServiceBuilder.addConfigDataSerializableFactories(this.dataSerializableFactories, this.config, this.classLoader);
            SerializationServiceBuilder.addConfigPortableFactories(this.portableFactories, this.config, this.classLoader);
            this.classDefinitions.addAll(this.config.getClassDefinitions());
        }
        InputOutputFactory inputOutputFactory = this.createInputOutputFactory();
        SerializationServiceImpl ss = new SerializationServiceImpl(inputOutputFactory, this.version, this.classLoader, this.dataSerializableFactories, this.portableFactories, this.classDefinitions, this.checkClassDefErrors, this.managedContext, this.enableCompression, this.enableSharedObject);
        if (this.config != null) {
            if (this.config.getGlobalSerializerConfig() != null) {
                GlobalSerializerConfig globalSerializerConfig = this.config.getGlobalSerializerConfig();
                Serializer serializer = globalSerializerConfig.getImplementation();
                if (serializer == null) {
                    try {
                        serializer = (Serializer)ClassLoaderUtil.newInstance(this.classLoader, globalSerializerConfig.getClassName());
                    }
                    catch (Exception e) {
                        throw new HazelcastSerializationException(e);
                    }
                }
                ss.registerGlobal(serializer);
            }
            Collection<SerializerConfig> typeSerializers = this.config.getSerializerConfigs();
            for (SerializerConfig serializerConfig : typeSerializers) {
                Class<?> typeClass;
                Serializer serializer = serializerConfig.getImplementation();
                if (serializer == null) {
                    try {
                        serializer = (Serializer)ClassLoaderUtil.newInstance(this.classLoader, serializerConfig.getClassName());
                    }
                    catch (Exception e) {
                        throw new HazelcastSerializationException(e);
                    }
                }
                if ((typeClass = serializerConfig.getTypeClass()) == null) {
                    try {
                        typeClass = ClassLoaderUtil.loadClass(this.classLoader, serializerConfig.getTypeClassName());
                    }
                    catch (ClassNotFoundException e) {
                        throw new HazelcastSerializationException(e);
                    }
                }
                ss.register(typeClass, serializer);
            }
        }
        return ss;
    }

    private InputOutputFactory createInputOutputFactory() {
        if (this.byteOrder == null) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
        }
        if (this.useNativeByteOrder || this.byteOrder == ByteOrder.nativeOrder()) {
            this.byteOrder = ByteOrder.nativeOrder();
            if (this.allowUnsafe && UnsafeInputOutputFactory.unsafeAvailable()) {
                return new UnsafeInputOutputFactory();
            }
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return new ByteArrayInputOutputFactory();
        }
        return new ByteBufferInputOutputFactory(this.byteOrder);
    }

    private static void addConfigDataSerializableFactories(Map<Integer, DataSerializableFactory> dataSerializableFactories, SerializationConfig config, ClassLoader cl) {
        for (Map.Entry<Integer, DataSerializableFactory> entry : config.getDataSerializableFactories().entrySet()) {
            if (entry.getKey() <= 0) {
                throw new IllegalArgumentException("DataSerializableFactory factoryId must be positive! -> " + entry.getValue());
            }
            if (dataSerializableFactories.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("DataSerializableFactory with factoryId '" + entry.getKey() + "' is already registered!");
            }
            dataSerializableFactories.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Integer, Object> entry : config.getDataSerializableFactoryClasses().entrySet()) {
            DataSerializableFactory f;
            if (entry.getKey() <= 0) {
                throw new IllegalArgumentException("DataSerializableFactory factoryId must be positive! -> " + (String)entry.getValue());
            }
            if (dataSerializableFactories.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("DataSerializableFactory with factoryId '" + entry.getKey() + "' is already registered!");
            }
            try {
                f = (DataSerializableFactory)ClassLoaderUtil.newInstance(cl, (String)entry.getValue());
            }
            catch (Exception e) {
                throw new HazelcastSerializationException(e);
            }
            dataSerializableFactories.put(entry.getKey(), f);
        }
    }

    private static void addConfigPortableFactories(Map<Integer, PortableFactory> portableFactories, SerializationConfig config, ClassLoader cl) {
        for (Map.Entry<Integer, PortableFactory> entry : config.getPortableFactories().entrySet()) {
            if (entry.getKey() <= 0) {
                throw new IllegalArgumentException("PortableFactory factoryId must be positive! -> " + entry.getValue());
            }
            if (portableFactories.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("PortableFactory with factoryId '" + entry.getKey() + "' is already registered!");
            }
            portableFactories.put(entry.getKey(), entry.getValue());
        }
        Map<Integer, String> portableFactoryClasses = config.getPortableFactoryClasses();
        for (Map.Entry<Integer, String> entry : portableFactoryClasses.entrySet()) {
            PortableFactory f;
            if (entry.getKey() <= 0) {
                throw new IllegalArgumentException("PortableFactory factoryId must be positive! -> " + entry.getValue());
            }
            if (portableFactories.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("PortableFactory with factoryId '" + entry.getKey() + "' is already registered!");
            }
            try {
                f = (PortableFactory)ClassLoaderUtil.newInstance(cl, entry.getValue());
            }
            catch (Exception e) {
                throw new HazelcastSerializationException(e);
            }
            portableFactories.put(entry.getKey(), f);
        }
    }
}

