/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.serialization;

import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.BufferObjectDataOutput;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ByteArraySerializer;
import com.hazelcast.nio.serialization.ByteArraySerializerAdapter;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionImpl;
import com.hazelcast.nio.serialization.ConstantSerializers;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.DataSerializer;
import com.hazelcast.nio.serialization.DefaultPortableReader;
import com.hazelcast.nio.serialization.DefaultSerializers;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.InputOutputFactory;
import com.hazelcast.nio.serialization.ObjectDataInputStream;
import com.hazelcast.nio.serialization.ObjectDataOutputStream;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableHookLoader;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableSerializer;
import com.hazelcast.nio.serialization.SerializationConstants;
import com.hazelcast.nio.serialization.SerializationContext;
import com.hazelcast.nio.serialization.SerializationService;
import com.hazelcast.nio.serialization.Serializer;
import com.hazelcast.nio.serialization.SerializerAdapter;
import com.hazelcast.nio.serialization.StreamSerializer;
import com.hazelcast.nio.serialization.StreamSerializerAdapter;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public final class SerializationServiceImpl
implements SerializationService {
    private static final int OUTPUT_BUFFER_SIZE = 4096;
    private static final int CONSTANT_SERIALIZERS_SIZE = SerializationConstants.CONSTANT_SERIALIZERS_LENGTH;
    private final IdentityHashMap<Class, SerializerAdapter> constantTypesMap = new IdentityHashMap(CONSTANT_SERIALIZERS_SIZE);
    private final SerializerAdapter[] constantTypeIds = new SerializerAdapter[CONSTANT_SERIALIZERS_SIZE];
    private final ConcurrentMap<Class, SerializerAdapter> typeMap = new ConcurrentHashMap<Class, SerializerAdapter>();
    private final ConcurrentMap<Integer, SerializerAdapter> idMap = new ConcurrentHashMap<Integer, SerializerAdapter>();
    private final AtomicReference<SerializerAdapter> global = new AtomicReference();
    private final InputOutputFactory inputOutputFactory;
    private final Queue<BufferObjectDataOutput> outputPool = new ConcurrentLinkedQueue<BufferObjectDataOutput>();
    private final PortableSerializer portableSerializer;
    private final SerializerAdapter dataSerializerAdapter;
    private final SerializerAdapter portableSerializerAdapter;
    private final ClassLoader classLoader;
    private final ManagedContext managedContext;
    private final SerializationContextImpl serializationContext;
    private volatile boolean active = true;

    SerializationServiceImpl(InputOutputFactory inputOutputFactory, int version, ClassLoader classLoader, Map<Integer, ? extends DataSerializableFactory> dataSerializableFactories, Map<Integer, ? extends PortableFactory> portableFactories, Collection<ClassDefinition> classDefinitions, boolean checkClassDefErrors, ManagedContext managedContext, boolean enableCompression, boolean enableSharedObject) {
        this.inputOutputFactory = inputOutputFactory;
        this.classLoader = classLoader;
        this.managedContext = managedContext;
        PortableHookLoader loader = new PortableHookLoader(portableFactories, classLoader);
        this.serializationContext = new SerializationContextImpl(loader.getFactories().keySet(), version);
        for (ClassDefinition cd : loader.getDefinitions()) {
            this.serializationContext.registerClassDefinition(cd);
        }
        this.dataSerializerAdapter = new StreamSerializerAdapter(this, new DataSerializer(dataSerializableFactories, classLoader));
        this.portableSerializer = new PortableSerializer(this.serializationContext, loader.getFactories());
        this.portableSerializerAdapter = new StreamSerializerAdapter(this, this.portableSerializer);
        this.registerConstant(DataSerializable.class, this.dataSerializerAdapter);
        this.registerConstant(Portable.class, this.portableSerializerAdapter);
        this.registerConstant(Byte.class, new ConstantSerializers.ByteSerializer());
        this.registerConstant(Boolean.class, new ConstantSerializers.BooleanSerializer());
        this.registerConstant(Character.class, new ConstantSerializers.CharSerializer());
        this.registerConstant(Short.class, new ConstantSerializers.ShortSerializer());
        this.registerConstant(Integer.class, new ConstantSerializers.IntegerSerializer());
        this.registerConstant(Long.class, new ConstantSerializers.LongSerializer());
        this.registerConstant(Float.class, new ConstantSerializers.FloatSerializer());
        this.registerConstant(Double.class, new ConstantSerializers.DoubleSerializer());
        this.registerConstant(byte[].class, new ConstantSerializers.TheByteArraySerializer());
        this.registerConstant(char[].class, new ConstantSerializers.CharArraySerializer());
        this.registerConstant(short[].class, new ConstantSerializers.ShortArraySerializer());
        this.registerConstant(int[].class, new ConstantSerializers.IntegerArraySerializer());
        this.registerConstant(long[].class, new ConstantSerializers.LongArraySerializer());
        this.registerConstant(float[].class, new ConstantSerializers.FloatArraySerializer());
        this.registerConstant(double[].class, new ConstantSerializers.DoubleArraySerializer());
        this.registerConstant(String.class, new ConstantSerializers.StringSerializer());
        this.safeRegister(Date.class, new DefaultSerializers.DateSerializer());
        this.safeRegister(BigInteger.class, new DefaultSerializers.BigIntegerSerializer());
        this.safeRegister(BigDecimal.class, new DefaultSerializers.BigDecimalSerializer());
        this.safeRegister(Externalizable.class, new DefaultSerializers.Externalizer(enableCompression));
        this.safeRegister(Serializable.class, new DefaultSerializers.ObjectSerializer(enableSharedObject, enableCompression));
        this.safeRegister(Class.class, new DefaultSerializers.ClassSerializer());
        this.registerClassDefinitions(classDefinitions, checkClassDefErrors);
    }

    private void registerClassDefinitions(Collection<ClassDefinition> classDefinitions, boolean checkClassDefErrors) {
        HashMap<Integer, ClassDefinition> classDefMap = new HashMap<Integer, ClassDefinition>(classDefinitions.size());
        for (ClassDefinition cd : classDefinitions) {
            if (classDefMap.containsKey(cd.getClassId())) {
                throw new HazelcastSerializationException("Duplicate registration found for class-id[" + cd.getClassId() + "]!");
            }
            classDefMap.put(cd.getClassId(), cd);
        }
        for (ClassDefinition classDefinition : classDefinitions) {
            this.registerClassDefinition(classDefinition, classDefMap, checkClassDefErrors);
        }
    }

    private void registerClassDefinition(ClassDefinition cd, Map<Integer, ClassDefinition> classDefMap, boolean checkClassDefErrors) {
        for (int i = 0; i < cd.getFieldCount(); ++i) {
            FieldDefinition fd = cd.get(i);
            if (fd.getType() != FieldType.PORTABLE && fd.getType() != FieldType.PORTABLE_ARRAY) continue;
            int classId = fd.getClassId();
            ClassDefinition nestedCd = classDefMap.get(classId);
            if (nestedCd != null) {
                ((ClassDefinitionImpl)cd).addClassDef(nestedCd);
                this.registerClassDefinition(nestedCd, classDefMap, checkClassDefErrors);
                this.serializationContext.registerClassDefinition(nestedCd);
                continue;
            }
            if (!checkClassDefErrors) continue;
            throw new HazelcastSerializationException("Could not find registered ClassDefinition for class-id: " + classId);
        }
        this.serializationContext.registerClassDefinition(cd);
    }

    @Override
    public Data toData(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Data) {
            return (Data)obj;
        }
        try {
            SerializerAdapter serializer = this.serializerFor(obj.getClass());
            if (serializer == null) {
                if (this.active) {
                    throw new HazelcastSerializationException("There is no suitable serializer for " + obj.getClass());
                }
                throw new HazelcastInstanceNotActiveException();
            }
            byte[] bytes = serializer.write(obj);
            Data data = new Data(serializer.getTypeId(), bytes);
            if (obj instanceof Portable) {
                Portable portable = (Portable)obj;
                data.classDefinition = this.serializationContext.lookup(portable.getFactoryId(), portable.getClassId());
            }
            if (obj instanceof PartitionAware) {
                Object pk = ((PartitionAware)obj).getPartitionKey();
                Data partitionKey = this.toData(pk);
                data.partitionHash = partitionKey == null ? -1 : partitionKey.getPartitionHash();
            }
            return data;
        }
        catch (Throwable e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public Object toObject(Data data) {
        if (data == null || data.bufferSize() == 0) {
            return null;
        }
        try {
            int typeId = data.type;
            SerializerAdapter serializer = this.serializerFor(typeId);
            if (serializer == null) {
                if (this.active) {
                    throw new HazelcastSerializationException("There is no suitable de-serializer for type " + typeId);
                }
                throw new HazelcastInstanceNotActiveException();
            }
            if (data.type == SerializationConstants.CONSTANT_TYPE_PORTABLE) {
                this.serializationContext.registerClassDefinition(data.classDefinition);
            }
            Object obj = serializer.read(data);
            if (this.managedContext != null) {
                obj = this.managedContext.initialize(obj);
            }
            return obj;
        }
        catch (Throwable e) {
            this.handleException(e);
            return null;
        }
    }

    @Override
    public void writeObject(ObjectDataOutput out, Object obj) {
        boolean isNull = obj == null;
        try {
            out.writeBoolean(isNull);
            if (isNull) {
                return;
            }
            SerializerAdapter serializer = this.serializerFor(obj.getClass());
            if (serializer == null) {
                if (this.active) {
                    throw new HazelcastSerializationException("There is no suitable serializer for " + obj.getClass());
                }
                throw new HazelcastInstanceNotActiveException();
            }
            out.writeInt(serializer.getTypeId());
            serializer.write(out, obj);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    @Override
    public Object readObject(ObjectDataInput in) {
        try {
            boolean isNull = in.readBoolean();
            if (isNull) {
                return null;
            }
            int typeId = in.readInt();
            SerializerAdapter serializer = this.serializerFor(typeId);
            if (serializer == null) {
                if (this.active) {
                    throw new HazelcastSerializationException("There is no suitable de-serializer for type " + typeId);
                }
                throw new HazelcastInstanceNotActiveException();
            }
            Object obj = serializer.read(in);
            if (this.managedContext != null) {
                obj = this.managedContext.initialize(obj);
            }
            return obj;
        }
        catch (Throwable e) {
            this.handleException(e);
            return null;
        }
    }

    private void handleException(Throwable e) {
        if (e instanceof OutOfMemoryError) {
            OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
            return;
        }
        if (e instanceof HazelcastSerializationException) {
            throw (HazelcastSerializationException)e;
        }
        throw new HazelcastSerializationException(e);
    }

    BufferObjectDataOutput pop() {
        BufferObjectDataOutput out = this.outputPool.poll();
        if (out == null) {
            out = this.inputOutputFactory.createOutput(4096, this);
        }
        return out;
    }

    void push(BufferObjectDataOutput out) {
        if (out != null) {
            out.clear();
            this.outputPool.offer(out);
        }
    }

    @Override
    public BufferObjectDataInput createObjectDataInput(byte[] data) {
        return this.inputOutputFactory.createInput(data, (SerializationService)this);
    }

    @Override
    public BufferObjectDataInput createObjectDataInput(Data data) {
        return this.inputOutputFactory.createInput(data, (SerializationService)this);
    }

    @Override
    public BufferObjectDataOutput createObjectDataOutput(int size) {
        return this.inputOutputFactory.createOutput(size, this);
    }

    @Override
    public ObjectDataOutputStream createObjectDataOutputStream(OutputStream out) {
        return new ObjectDataOutputStream(out, this);
    }

    @Override
    public ObjectDataInputStream createObjectDataInputStream(InputStream in) {
        return new ObjectDataInputStream(in, this);
    }

    @Override
    public ObjectDataOutputStream createObjectDataOutputStream(OutputStream out, ByteOrder order) {
        return new ObjectDataOutputStream(out, this, order);
    }

    @Override
    public ObjectDataInputStream createObjectDataInputStream(InputStream in, ByteOrder order) {
        return new ObjectDataInputStream(in, this, order);
    }

    @Override
    public void register(Class type, Serializer serializer) {
        if (type == null) {
            throw new IllegalArgumentException("Class type information is required!");
        }
        if (serializer.getTypeId() <= 0) {
            throw new IllegalArgumentException("Type id must be positive! Current: " + serializer.getTypeId() + ", Serializer: " + serializer);
        }
        this.safeRegister(type, this.createSerializerAdapter(serializer));
    }

    @Override
    public void registerGlobal(Serializer serializer) {
        if (!this.global.compareAndSet(null, this.createSerializerAdapter(serializer))) {
            throw new IllegalStateException("Fallback serializer is already registered!");
        }
    }

    private SerializerAdapter createSerializerAdapter(Serializer serializer) {
        SerializerAdapter s;
        if (serializer instanceof StreamSerializer) {
            s = new StreamSerializerAdapter(this, (StreamSerializer)serializer);
        } else if (serializer instanceof ByteArraySerializer) {
            s = new ByteArraySerializerAdapter((ByteArraySerializer)serializer);
        } else {
            throw new IllegalArgumentException("Serializer must be instance of either StreamSerializer or ByteArraySerializer!");
        }
        return s;
    }

    public SerializerAdapter serializerFor(Class type) {
        if (DataSerializable.class.isAssignableFrom(type)) {
            return this.dataSerializerAdapter;
        }
        if (Portable.class.isAssignableFrom(type)) {
            return this.portableSerializerAdapter;
        }
        SerializerAdapter serializer = this.constantTypesMap.get(type);
        if (serializer != null) {
            return serializer;
        }
        serializer = (SerializerAdapter)this.typeMap.get(type);
        if (serializer == null) {
            LinkedHashSet<Class> interfaces = new LinkedHashSet<Class>(5);
            SerializationServiceImpl.getInterfaces(type, interfaces);
            for (Class typeSuperclass = type.getSuperclass(); typeSuperclass != null && (serializer = this.registerFromSuperType(type, typeSuperclass)) == null; typeSuperclass = typeSuperclass.getSuperclass()) {
                SerializationServiceImpl.getInterfaces(typeSuperclass, interfaces);
            }
            if (serializer == null) {
                Class typeInterface;
                Iterator i$ = interfaces.iterator();
                while (i$.hasNext() && (serializer = this.registerFromSuperType(type, typeInterface = (Class)i$.next())) == null) {
                }
            }
            if (serializer == null && (serializer = this.global.get()) != null) {
                this.safeRegister(type, serializer);
            }
        }
        return serializer;
    }

    private static void getInterfaces(Class clazz, Set<Class> interfaces) {
        Class<?>[] classes = clazz.getInterfaces();
        if (classes.length > 0) {
            Collections.addAll(interfaces, classes);
            for (Class<?> cl : classes) {
                SerializationServiceImpl.getInterfaces(cl, interfaces);
            }
        }
    }

    private SerializerAdapter registerFromSuperType(Class type, Class superType) {
        SerializerAdapter serializer = (SerializerAdapter)this.typeMap.get(superType);
        if (serializer != null) {
            this.safeRegister(type, serializer);
        }
        return serializer;
    }

    private void registerConstant(Class type, Serializer serializer) {
        this.registerConstant(type, this.createSerializerAdapter(serializer));
    }

    private void registerConstant(Class type, SerializerAdapter serializer) {
        this.constantTypesMap.put(type, serializer);
        this.constantTypeIds[this.indexForDefaultType((int)serializer.getTypeId())] = serializer;
    }

    private void safeRegister(Class type, Serializer serializer) {
        this.safeRegister(type, this.createSerializerAdapter(serializer));
    }

    private void safeRegister(Class type, SerializerAdapter serializer) {
        if (this.constantTypesMap.containsKey(type)) {
            throw new IllegalArgumentException("[" + type + "] serializer cannot be overridden!");
        }
        SerializerAdapter current = this.typeMap.putIfAbsent(type, serializer);
        if (current != null && current.getImpl().getClass() != serializer.getImpl().getClass()) {
            throw new IllegalStateException("Serializer[" + current + "] has been already registered for type: " + type);
        }
        current = this.idMap.putIfAbsent(serializer.getTypeId(), serializer);
        if (current != null && current.getImpl().getClass() != serializer.getImpl().getClass()) {
            throw new IllegalStateException("Serializer [" + current + "] has been already registered for type-id: " + serializer.getTypeId());
        }
    }

    public SerializerAdapter serializerFor(int typeId) {
        int index;
        if (typeId < 0 && (index = this.indexForDefaultType(typeId)) < CONSTANT_SERIALIZERS_SIZE) {
            return this.constantTypeIds[index];
        }
        return (SerializerAdapter)this.idMap.get(typeId);
    }

    private int indexForDefaultType(int typeId) {
        return -typeId - 1;
    }

    @Override
    public SerializationContext getSerializationContext() {
        return this.serializationContext;
    }

    @Override
    public PortableReader createPortableReader(Data data) {
        return new DefaultPortableReader(this.portableSerializer, this.createObjectDataInput(data), data.getClassDefinition());
    }

    public void destroy() {
        this.active = false;
        for (SerializerAdapter serializer : this.typeMap.values()) {
            serializer.destroy();
        }
        this.typeMap.clear();
        this.idMap.clear();
        this.global.set(null);
        this.constantTypesMap.clear();
        for (BufferObjectDataOutput output : this.outputPool) {
            IOUtil.closeResource(output);
        }
        this.outputPool.clear();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    private static void compress(byte[] input, DataOutput out) throws IOException {
        Deflater deflater = new Deflater();
        deflater.setLevel(9);
        deflater.setInput(input);
        deflater.finish();
        byte[] buf = new byte[input.length / 10];
        while (!deflater.finished()) {
            int count = deflater.deflate(buf);
            out.write(buf, 0, count);
        }
        deflater.end();
    }

    private static void decompress(byte[] compressedData, DataOutput out) throws IOException {
        Inflater inflater = new Inflater();
        inflater.setInput(compressedData);
        byte[] buf = new byte[1024];
        while (!inflater.finished()) {
            try {
                int count = inflater.inflate(buf);
                out.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                throw new IOException(e);
            }
        }
        inflater.end();
    }

    private static long combineToLong(int x, int y) {
        return (long)x << 32 | (long)y & 0xFFFFFFFL;
    }

    private static int extractInt(long value, boolean lowerBits) {
        return lowerBits ? (int)value : (int)(value >> 32);
    }

    private class PortableContext {
        final ConcurrentMap<Long, ClassDefinitionImpl> versionedDefinitions = new ConcurrentHashMap<Long, ClassDefinitionImpl>();

        private PortableContext() {
        }

        ClassDefinition lookup(int classId, int version) {
            return (ClassDefinition)this.versionedDefinitions.get(SerializationServiceImpl.combineToLong(classId, version));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ClassDefinition createClassDefinition(byte[] compressedBinary) throws IOException {
            byte[] binary;
            BufferObjectDataOutput out = SerializationServiceImpl.this.pop();
            try {
                SerializationServiceImpl.decompress(compressedBinary, out);
                binary = out.toByteArray();
            }
            finally {
                SerializationServiceImpl.this.push(out);
            }
            ClassDefinitionImpl cd = new ClassDefinitionImpl();
            cd.readData(SerializationServiceImpl.this.inputOutputFactory.createInput(binary, (SerializationService)SerializationServiceImpl.this));
            cd.setBinary(compressedBinary);
            ClassDefinitionImpl currentCD = this.versionedDefinitions.putIfAbsent(SerializationServiceImpl.combineToLong(cd.classId, SerializationServiceImpl.this.serializationContext.getVersion()), cd);
            if (currentCD == null) {
                SerializationServiceImpl.this.serializationContext.registerNestedDefinitions(cd);
                return cd;
            }
            return currentCD;
        }

        ClassDefinition registerClassDefinition(ClassDefinition cd) {
            long versionedClassId;
            ClassDefinitionImpl currentClassDef;
            if (cd == null) {
                return null;
            }
            ClassDefinitionImpl cdImpl = (ClassDefinitionImpl)cd;
            if (cdImpl.getVersion() < 0) {
                cdImpl.version = SerializationServiceImpl.this.serializationContext.getVersion();
            }
            if ((currentClassDef = this.versionedDefinitions.putIfAbsent(versionedClassId = SerializationServiceImpl.combineToLong(cdImpl.getClassId(), cdImpl.getVersion()), cdImpl)) == null) {
                SerializationServiceImpl.this.serializationContext.registerNestedDefinitions(cdImpl);
                if (cdImpl.getBinary() == null) {
                    BufferObjectDataOutput out = SerializationServiceImpl.this.pop();
                    try {
                        cdImpl.writeData(out);
                        byte[] binary = out.toByteArray();
                        out.clear();
                        SerializationServiceImpl.compress(binary, out);
                        cdImpl.setBinary(out.toByteArray());
                    }
                    catch (IOException e) {
                        throw new HazelcastSerializationException(e);
                    }
                    finally {
                        SerializationServiceImpl.this.push(out);
                    }
                }
                return cd;
            }
            return currentClassDef;
        }
    }

    private class SerializationContextImpl
    implements SerializationContext {
        final int ctxVersion;
        final Map<Integer, PortableContext> portableContextMap;

        private SerializationContextImpl(Collection<Integer> portableFactories, int version) {
            this.ctxVersion = version;
            HashMap<Integer, PortableContext> portableMap = new HashMap<Integer, PortableContext>();
            for (int factoryId : portableFactories) {
                portableMap.put(factoryId, new PortableContext());
            }
            this.portableContextMap = portableMap;
        }

        @Override
        public ClassDefinition lookup(int factoryId, int classId) {
            return this.getPortableContext(factoryId).lookup(classId, this.ctxVersion);
        }

        @Override
        public ClassDefinition lookup(int factoryId, int classId, int version) {
            return this.getPortableContext(factoryId).lookup(classId, version);
        }

        @Override
        public ClassDefinition createClassDefinition(int factoryId, byte[] compressedBinary) throws IOException {
            return this.getPortableContext(factoryId).createClassDefinition(compressedBinary);
        }

        @Override
        public ClassDefinition registerClassDefinition(ClassDefinition cd) {
            return this.getPortableContext(cd.getFactoryId()).registerClassDefinition(cd);
        }

        private void registerNestedDefinitions(ClassDefinitionImpl cd) {
            Set<ClassDefinition> nestedDefinitions = cd.getNestedClassDefinitions();
            for (ClassDefinition classDefinition : nestedDefinitions) {
                ClassDefinitionImpl nestedCD = (ClassDefinitionImpl)classDefinition;
                this.registerClassDefinition(nestedCD);
                this.registerNestedDefinitions(nestedCD);
            }
        }

        private PortableContext getPortableContext(int factoryId) {
            PortableContext ctx = this.portableContextMap.get(factoryId);
            if (ctx == null) {
                throw new HazelcastSerializationException("Could not find PortableFactory for factoryId: " + factoryId);
            }
            return ctx;
        }

        @Override
        public int getVersion() {
            return this.ctxVersion;
        }
    }
}

