/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.queue.proxy;

import com.hazelcast.monitor.LocalQueueStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.queue.QueueService;
import com.hazelcast.queue.proxy.QueueIterator;
import com.hazelcast.queue.proxy.QueueProxy;
import com.hazelcast.queue.proxy.QueueProxySupport;
import com.hazelcast.spi.NodeEngine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;

public class DataQueueProxy
extends QueueProxySupport
implements QueueProxy<Data> {
    public DataQueueProxy(String name, QueueService queueService, NodeEngine nodeEngine) {
        super(name, queueService, nodeEngine);
    }

    @Override
    public LocalQueueStats getLocalQueueStats() {
        return ((QueueService)this.getService()).createLocalQueueStats(this.name, this.partitionId);
    }

    @Override
    public boolean add(Data data) {
        boolean res = this.offer(data);
        if (!res) {
            throw new IllegalStateException("Queue is full!");
        }
        return res;
    }

    @Override
    public boolean offer(Data data) {
        try {
            return this.offer(data, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ex) {
            return false;
        }
    }

    @Override
    public void put(Data data) throws InterruptedException {
        this.offer(data, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean offer(Data data, long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.offerInternal(data, timeUnit.toMillis(timeout));
    }

    @Override
    public Data take() throws InterruptedException {
        return this.poll(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Data poll(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return (Data)this.pollInternal(timeUnit.toMillis(timeout));
    }

    @Override
    public int remainingCapacity() {
        return this.config.getMaxSize() - this.size();
    }

    @Override
    public boolean remove(Object o) {
        return this.removeInternal((Data)o);
    }

    @Override
    public boolean contains(Object o) {
        ArrayList<Data> dataSet = new ArrayList<Data>(1);
        dataSet.add((Data)o);
        return this.containsInternal(dataSet);
    }

    @Override
    public int drainTo(Collection<? super Data> objects) {
        return this.drainTo(objects, -1);
    }

    @Override
    public int drainTo(Collection<? super Data> objects, int i) {
        if (this.equals(objects)) {
            throw new IllegalArgumentException("Can not drain to same Queue");
        }
        Collection<Data> dataList = this.drainInternal(i);
        objects.addAll(dataList);
        return dataList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<Data> iterator() {
        return new QueueIterator<Data>(this.listInternal().iterator(), null, true);
    }

    @Override
    public Object[] toArray() {
        List<Data> list = this.listInternal();
        return list.toArray();
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        return this.containsInternal(objects);
    }

    @Override
    public boolean addAll(Collection<? extends Data> datas) {
        return this.addAllInternal(datas);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        return this.compareAndRemove(objects, false);
    }

    @Override
    public Data remove() {
        Data res = this.poll();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    @Override
    public Data poll() {
        try {
            return this.poll(0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    @Override
    public Data element() {
        Data res = this.peek();
        if (res == null) {
            throw new NoSuchElementException("Queue is empty!");
        }
        return res;
    }

    @Override
    public Data peek() {
        return (Data)this.peekInternal();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        List<Data> list = this.listInternal();
        return list.toArray(ts);
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        return this.compareAndRemove(objects, true);
    }
}

