/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.concurrent.semaphore.client.AcquireRequest;
import com.hazelcast.concurrent.semaphore.client.AvailableRequest;
import com.hazelcast.concurrent.semaphore.client.DrainRequest;
import com.hazelcast.concurrent.semaphore.client.InitRequest;
import com.hazelcast.concurrent.semaphore.client.ReduceRequest;
import com.hazelcast.concurrent.semaphore.client.ReleaseRequest;
import com.hazelcast.concurrent.semaphore.client.SemaphoreDestroyRequest;
import com.hazelcast.core.ISemaphore;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.ExceptionUtil;
import java.util.concurrent.TimeUnit;

public class ClientSemaphoreProxy
extends ClientProxy
implements ISemaphore {
    private final String name;
    private Data key;

    public ClientSemaphoreProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    @Override
    public boolean init(int permits) {
        this.checkNegative(permits);
        InitRequest request = new InitRequest(this.name, permits);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public void acquire() throws InterruptedException {
        this.acquire(1);
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        this.checkNegative(permits);
        AcquireRequest request = new AcquireRequest(this.name, permits, -1L);
        this.invoke(request);
    }

    @Override
    public int availablePermits() {
        AvailableRequest request = new AvailableRequest(this.name);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public int drainPermits() {
        DrainRequest request = new DrainRequest(this.name);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public void reducePermits(int reduction) {
        this.checkNegative(reduction);
        ReduceRequest request = new ReduceRequest(this.name, reduction);
        this.invoke(request);
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        this.checkNegative(permits);
        ReleaseRequest request = new ReleaseRequest(this.name, permits);
        this.invoke(request);
    }

    @Override
    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryAcquire(int permits) {
        this.checkNegative(permits);
        try {
            return this.tryAcquire(permits, 0L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryAcquire(long timeout, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, timeout, unit);
    }

    @Override
    public boolean tryAcquire(int permits, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkNegative(permits);
        AcquireRequest request = new AcquireRequest(this.name, permits, unit.toMillis(timeout));
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    protected void onDestroy() {
        SemaphoreDestroyRequest request = new SemaphoreDestroyRequest(this.name);
        this.invoke(request);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private <T> T invoke(Object req) {
        try {
            return this.getContext().getInvocationService().invokeOnKeyOwner(req, this.getKey());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    public Data getKey() {
        if (this.key == null) {
            this.key = this.getContext().getSerializationService().toData(this.name);
        }
        return this.key;
    }

    private void checkNegative(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits cannot be negative!");
        }
    }
}

