/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.nearcache.ClientNearCache;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.IMap;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.map.MapEntrySet;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.MapKeySet;
import com.hazelcast.map.MapValueCollection;
import com.hazelcast.map.SimpleEntryView;
import com.hazelcast.map.client.MapAddEntryListenerRequest;
import com.hazelcast.map.client.MapAddIndexRequest;
import com.hazelcast.map.client.MapAddInterceptorRequest;
import com.hazelcast.map.client.MapClearRequest;
import com.hazelcast.map.client.MapContainsKeyRequest;
import com.hazelcast.map.client.MapContainsValueRequest;
import com.hazelcast.map.client.MapDeleteRequest;
import com.hazelcast.map.client.MapDestroyRequest;
import com.hazelcast.map.client.MapEntrySetRequest;
import com.hazelcast.map.client.MapEvictRequest;
import com.hazelcast.map.client.MapExecuteOnAllKeysRequest;
import com.hazelcast.map.client.MapExecuteOnKeyRequest;
import com.hazelcast.map.client.MapFlushRequest;
import com.hazelcast.map.client.MapGetAllRequest;
import com.hazelcast.map.client.MapGetEntryViewRequest;
import com.hazelcast.map.client.MapGetRequest;
import com.hazelcast.map.client.MapIsLockedRequest;
import com.hazelcast.map.client.MapKeySetRequest;
import com.hazelcast.map.client.MapLockRequest;
import com.hazelcast.map.client.MapPutAllRequest;
import com.hazelcast.map.client.MapPutIfAbsentRequest;
import com.hazelcast.map.client.MapPutRequest;
import com.hazelcast.map.client.MapPutTransientRequest;
import com.hazelcast.map.client.MapQueryRequest;
import com.hazelcast.map.client.MapRemoveIfSameRequest;
import com.hazelcast.map.client.MapRemoveInterceptorRequest;
import com.hazelcast.map.client.MapRemoveRequest;
import com.hazelcast.map.client.MapReplaceIfSameRequest;
import com.hazelcast.map.client.MapReplaceRequest;
import com.hazelcast.map.client.MapSetRequest;
import com.hazelcast.map.client.MapSizeRequest;
import com.hazelcast.map.client.MapTryPutRequest;
import com.hazelcast.map.client.MapTryRemoveRequest;
import com.hazelcast.map.client.MapUnlockRequest;
import com.hazelcast.map.client.MapValuesRequest;
import com.hazelcast.monitor.LocalMapStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.spi.impl.PortableEntryEvent;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.IterationType;
import com.hazelcast.util.QueryResultSet;
import com.hazelcast.util.ThreadUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ClientMapProxy<K, V>
extends ClientProxy
implements IMap<K, V> {
    private final String name;
    private volatile ClientNearCache nearCache;
    private String nearCacheListenerId;
    private final AtomicBoolean nearCacheInitialized = new AtomicBoolean();

    public ClientMapProxy(String serviceName, String name) {
        super(serviceName, name);
        this.name = name;
    }

    @Override
    public boolean containsKey(Object key) {
        Data keyData = this.toData(key);
        MapContainsKeyRequest request = new MapContainsKeyRequest(this.name, keyData);
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public boolean containsValue(Object value) {
        Data valueData = this.toData(value);
        MapContainsValueRequest request = new MapContainsValueRequest(this.name, valueData);
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public V get(Object key) {
        Object cached;
        this.initNearCache();
        Data keyData = this.toData(key);
        if (this.nearCache != null && (cached = this.nearCache.get(keyData)) != null) {
            return (V)cached;
        }
        MapGetRequest request = new MapGetRequest(this.name, keyData);
        Object result = this.invoke(request, keyData);
        if (this.nearCache != null) {
            this.nearCache.put(keyData, result);
        }
        return (V)result;
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, -1L, null);
    }

    @Override
    public V remove(Object key) {
        Data keyData = this.toData(key);
        MapRemoveRequest request = new MapRemoveRequest(this.name, keyData, ThreadUtil.getThreadId());
        return (V)this.invoke(request, keyData);
    }

    @Override
    public boolean remove(Object key, Object value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapRemoveIfSameRequest request = new MapRemoveIfSameRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public void delete(Object key) {
        Data keyData = this.toData(key);
        MapDeleteRequest request = new MapDeleteRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke(request, keyData);
    }

    @Override
    public void flush() {
        MapFlushRequest request = new MapFlushRequest(this.name);
        this.invoke(request);
    }

    @Override
    public Future<V> getAsync(final K key) {
        Future f = this.getContext().getExecutionService().submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return ClientMapProxy.this.get(key);
            }
        });
        return f;
    }

    @Override
    public Future<V> putAsync(K key, V value) {
        return this.putAsync(key, value, -1L, null);
    }

    @Override
    public Future<V> putAsync(final K key, final V value, final long ttl, final TimeUnit timeunit) {
        Future f = this.getContext().getExecutionService().submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return ClientMapProxy.this.put(key, value, ttl, timeunit);
            }
        });
        return f;
    }

    @Override
    public Future<V> removeAsync(final K key) {
        Future f = this.getContext().getExecutionService().submit(new Callable<V>(){

            @Override
            public V call() throws Exception {
                return ClientMapProxy.this.remove(key);
            }
        });
        return f;
    }

    @Override
    public boolean tryRemove(K key, long timeout, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        MapTryRemoveRequest request = new MapTryRemoveRequest(this.name, keyData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public boolean tryPut(K key, V value, long timeout, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapTryPutRequest request = new MapTryPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), timeunit.toMillis(timeout));
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public V put(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapPutRequest request = new MapPutRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        return (V)this.invoke(request, keyData);
    }

    @Override
    public void putTransient(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapPutTransientRequest request = new MapPutTransientRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        this.invoke(request);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.putIfAbsent(key, value, -1L, null);
    }

    @Override
    public V putIfAbsent(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapPutIfAbsentRequest request = new MapPutIfAbsentRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        return (V)this.invoke(request, keyData);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Data keyData = this.toData(key);
        Data oldValueData = this.toData(oldValue);
        Data newValueData = this.toData(newValue);
        MapReplaceIfSameRequest request = new MapReplaceIfSameRequest(this.name, keyData, oldValueData, newValueData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public V replace(K key, V value) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapReplaceRequest request = new MapReplaceRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        return (V)this.invoke(request, keyData);
    }

    @Override
    public void set(K key, V value, long ttl, TimeUnit timeunit) {
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        MapSetRequest request = new MapSetRequest(this.name, keyData, valueData, ThreadUtil.getThreadId(), this.getTimeInMillis(ttl, timeunit));
        this.invoke(request, keyData);
    }

    @Override
    public void lock(K key) {
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke(request, keyData);
    }

    @Override
    public void lock(K key, long leaseTime, TimeUnit timeUnit) {
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), -1L);
        this.invoke(request, keyData);
    }

    @Override
    public boolean isLocked(K key) {
        Data keyData = this.toData(key);
        MapIsLockedRequest request = new MapIsLockedRequest(this.name, keyData);
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public boolean tryLock(K key) {
        try {
            return this.tryLock(key, 0L, null);
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Override
    public boolean tryLock(K key, long time, TimeUnit timeunit) throws InterruptedException {
        Data keyData = this.toData(key);
        MapLockRequest request = new MapLockRequest(this.name, keyData, ThreadUtil.getThreadId(), Long.MAX_VALUE, this.getTimeInMillis(time, timeunit));
        Boolean result = (Boolean)this.invoke(request, keyData);
        return result;
    }

    @Override
    public void unlock(K key) {
        Data keyData = this.toData(key);
        MapUnlockRequest request = new MapUnlockRequest(this.name, keyData, ThreadUtil.getThreadId(), false);
        this.invoke(request, keyData);
    }

    @Override
    public void forceUnlock(K key) {
        Data keyData = this.toData(key);
        MapUnlockRequest request = new MapUnlockRequest(this.name, keyData, ThreadUtil.getThreadId(), true);
        this.invoke(request, keyData);
    }

    @Override
    public String addLocalEntryListener(EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public String addInterceptor(MapInterceptor interceptor) {
        MapAddInterceptorRequest request = new MapAddInterceptorRequest(this.name, interceptor);
        return (String)this.invoke(request);
    }

    @Override
    public void removeInterceptor(String id) {
        MapRemoveInterceptorRequest request = new MapRemoveInterceptorRequest(this.name, id);
        this.invoke(request);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, boolean includeValue) {
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, handler);
    }

    @Override
    public boolean removeEntryListener(String id) {
        return this.stopListening(id);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, keyData, includeValue);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, keyData, handler);
    }

    @Override
    public String addEntryListener(EntryListener<K, V> listener, Predicate<K, V> predicate, K key, boolean includeValue) {
        Data keyData = this.toData(key);
        MapAddEntryListenerRequest request = new MapAddEntryListenerRequest(this.name, keyData, includeValue, predicate);
        EventHandler<PortableEntryEvent> handler = this.createHandler(listener, includeValue);
        return this.listen(request, keyData, handler);
    }

    @Override
    public EntryView<K, V> getEntryView(K key) {
        Data keyData = this.toData(key);
        MapGetEntryViewRequest request = new MapGetEntryViewRequest(this.name, keyData);
        SimpleEntryView entryView = (SimpleEntryView)this.invoke(request, keyData);
        if (entryView == null) {
            return null;
        }
        Data value = (Data)entryView.getValue();
        entryView.setKey(key);
        entryView.setValue(this.toObject(value));
        return entryView;
    }

    @Override
    public boolean evict(K key) {
        Data keyData = this.toData(key);
        MapEvictRequest request = new MapEvictRequest(this.name, keyData, ThreadUtil.getThreadId());
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public Set<K> keySet() {
        MapKeySetRequest request = new MapKeySetRequest(this.name);
        MapKeySet mapKeySet = (MapKeySet)this.invoke(request);
        Set<Data> keySetData = mapKeySet.getKeySet();
        HashSet keySet = new HashSet(keySetData.size());
        for (Data data : keySetData) {
            Object key = this.toObject(data);
            keySet.add(key);
        }
        return keySet;
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        HashSet<Data> keySet = new HashSet<Data>(keys.size());
        for (K key : keys) {
            keySet.add(this.toData(key));
        }
        MapGetAllRequest request = new MapGetAllRequest(this.name, keySet);
        MapEntrySet mapEntrySet = (MapEntrySet)this.invoke(request);
        HashMap result = new HashMap();
        Set<Map.Entry<Data, Data>> entrySet = mapEntrySet.getEntrySet();
        for (Map.Entry<Data, Data> dataEntry : entrySet) {
            result.put(this.toObject(dataEntry.getKey()), this.toObject(dataEntry.getValue()));
        }
        return result;
    }

    @Override
    public Collection<V> values() {
        MapValuesRequest request = new MapValuesRequest(this.name);
        MapValueCollection mapValueCollection = (MapValueCollection)this.invoke(request);
        Collection<Data> collectionData = mapValueCollection.getValues();
        ArrayList collection = new ArrayList(collectionData.size());
        for (Data data : collectionData) {
            Object value = this.toObject(data);
            collection.add(value);
        }
        return collection;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        MapEntrySetRequest request = new MapEntrySetRequest(this.name);
        MapEntrySet result = (MapEntrySet)this.invoke(request);
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        Set<Map.Entry<Data, Data>> entries = result.getEntrySet();
        for (Map.Entry<Data, Data> dataEntry : entries) {
            Data keyData = dataEntry.getKey();
            Data valueData = dataEntry.getValue();
            Object key = this.toObject(keyData);
            Object value = this.toObject(valueData);
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        return entrySet;
    }

    @Override
    public Set<K> keySet(Predicate predicate) {
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.KEY);
        QueryResultSet result = (QueryResultSet)this.invoke(request);
        HashSet keySet = new HashSet(result.size());
        for (Object data : result) {
            Object key = this.toObject((Data)data);
            keySet.add(key);
        }
        return keySet;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet(Predicate predicate) {
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.ENTRY);
        QueryResultSet result = (QueryResultSet)this.invoke(request);
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>(result.size());
        for (Object data : result) {
            AbstractMap.SimpleImmutableEntry dataEntry = (AbstractMap.SimpleImmutableEntry)data;
            Object key = this.toObject((Data)dataEntry.getKey());
            Object value = this.toObject((Data)dataEntry.getValue());
            entrySet.add(new AbstractMap.SimpleEntry(key, value));
        }
        return entrySet;
    }

    @Override
    public Collection<V> values(Predicate predicate) {
        MapQueryRequest request = new MapQueryRequest(this.name, predicate, IterationType.VALUE);
        QueryResultSet result = (QueryResultSet)this.invoke(request);
        ArrayList values = new ArrayList(result.size());
        for (Object data : result) {
            Object value = this.toObject((Data)data);
            values.add(value);
        }
        return values;
    }

    @Override
    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public Set<K> localKeySet(Predicate predicate) {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public void addIndex(String attribute, boolean ordered) {
        MapAddIndexRequest request = new MapAddIndexRequest(this.name, attribute, ordered);
        this.invoke(request);
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    public Object executeOnKey(K key, EntryProcessor entryProcessor) {
        Data keyData = this.toData(key);
        MapExecuteOnKeyRequest request = new MapExecuteOnKeyRequest(this.name, entryProcessor, keyData);
        return this.invoke(request, keyData);
    }

    @Override
    public Map<K, Object> executeOnEntries(EntryProcessor entryProcessor) {
        MapExecuteOnAllKeysRequest request = new MapExecuteOnAllKeysRequest(this.name, entryProcessor);
        MapEntrySet entrySet = (MapEntrySet)this.invoke(request);
        HashMap result = new HashMap();
        for (Map.Entry<Data, Data> dataEntry : entrySet.getEntrySet()) {
            Data keyData = dataEntry.getKey();
            Data valueData = dataEntry.getValue();
            Object key = this.toObject(keyData);
            result.put(key, this.toObject(valueData));
        }
        return result;
    }

    @Override
    public void set(K key, V value) {
        this.set(key, value, -1L, null);
    }

    @Override
    public int size() {
        MapSizeRequest request = new MapSizeRequest(this.name);
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        MapEntrySet entrySet = new MapEntrySet();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            entrySet.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(this.toData(entry.getKey()), this.toData(entry.getValue())));
        }
        MapPutAllRequest request = new MapPutAllRequest(this.name, entrySet);
        this.invoke(request);
    }

    @Override
    public void clear() {
        MapClearRequest request = new MapClearRequest(this.name);
        this.invoke(request);
    }

    @Override
    protected void onDestroy() {
        if (this.nearCacheListenerId != null) {
            this.removeEntryListener(this.nearCacheListenerId);
        }
        this.nearCache.clear();
        MapDestroyRequest request = new MapDestroyRequest(this.name);
        this.invoke(request);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private Data toData(Object o) {
        return this.getContext().getSerializationService().toData(o);
    }

    private <T> T toObject(Data data) {
        return (T)this.getContext().getSerializationService().toObject(data);
    }

    private <T> T invoke(Object req, Data keyData) {
        try {
            return this.getContext().getInvocationService().invokeOnKeyOwner(req, keyData);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private <T> T invoke(Object req) {
        try {
            return this.getContext().getInvocationService().invokeOnRandomTarget(req);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    private EventHandler<PortableEntryEvent> createHandler(final EntryListener<K, V> listener, final boolean includeValue) {
        return new EventHandler<PortableEntryEvent>(){

            @Override
            public void handle(PortableEntryEvent event) {
                Object value = null;
                Object oldValue = null;
                if (includeValue) {
                    value = ClientMapProxy.this.toObject(event.getValue());
                    oldValue = ClientMapProxy.this.toObject(event.getOldValue());
                }
                Object key = ClientMapProxy.this.toObject(event.getKey());
                MemberImpl member = ClientMapProxy.this.getContext().getClusterService().getMember(event.getUuid());
                EntryEvent<Object, Object> entryEvent = new EntryEvent<Object, Object>(ClientMapProxy.this.name, member, event.getEventType().getType(), key, oldValue, value);
                switch (event.getEventType()) {
                    case ADDED: {
                        listener.entryAdded(entryEvent);
                        break;
                    }
                    case REMOVED: {
                        listener.entryRemoved(entryEvent);
                        break;
                    }
                    case UPDATED: {
                        listener.entryUpdated(entryEvent);
                        break;
                    }
                    case EVICTED: {
                        listener.entryEvicted(entryEvent);
                    }
                }
            }
        };
    }

    private void initNearCache() {
        if (this.nearCacheInitialized.compareAndSet(false, true)) {
            NearCacheConfig nearCacheConfig = this.getContext().getClientConfig().getNearCacheConfig(this.name);
            if (nearCacheConfig == null) {
                return;
            }
            ClientNearCache _nearCache = new ClientNearCache(this.name, this.getContext(), nearCacheConfig);
            if (nearCacheConfig.isInvalidateOnChange()) {
                try {
                    this.nearCacheListenerId = this.addEntryListener(new EntryListener<K, V>(){

                        @Override
                        public void entryAdded(EntryEvent<K, V> event) {
                            this.invalidate(event);
                        }

                        @Override
                        public void entryRemoved(EntryEvent<K, V> event) {
                            this.invalidate(event);
                        }

                        @Override
                        public void entryUpdated(EntryEvent<K, V> event) {
                            this.invalidate(event);
                        }

                        @Override
                        public void entryEvicted(EntryEvent<K, V> event) {
                            this.invalidate(event);
                        }

                        void invalidate(EntryEvent<K, V> event) {
                            Data key = ClientMapProxy.this.toData(event.getKey());
                            ClientMapProxy.this.nearCache.invalidate(key);
                        }
                    }, false);
                }
                catch (Exception e) {
                    _nearCache = null;
                    Logger.getLogger(ClientMapProxy.class).severe("-----------------\n Near Cache is not initialized!!! \n-----------------", e);
                }
            }
            this.nearCache = _nearCache;
        }
    }
}

