/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.proxy;

import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.monitor.LocalTopicStats;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.topic.client.AddMessageListenerRequest;
import com.hazelcast.topic.client.PortableMessage;
import com.hazelcast.topic.client.PublishRequest;
import com.hazelcast.topic.client.TopicDestroyRequest;
import com.hazelcast.util.ExceptionUtil;

public class ClientTopicProxy<E>
extends ClientProxy
implements ITopic<E> {
    private final String name;
    private Data key;

    public ClientTopicProxy(String serviceName, String objectId) {
        super(serviceName, objectId);
        this.name = objectId;
    }

    @Override
    public void publish(E message) {
        Data data = this.getContext().getSerializationService().toData(message);
        PublishRequest request = new PublishRequest(this.name, data);
        this.invoke(request);
    }

    @Override
    public String addMessageListener(final MessageListener<E> listener) {
        AddMessageListenerRequest request = new AddMessageListenerRequest(this.name);
        EventHandler<PortableMessage> handler = new EventHandler<PortableMessage>(){

            @Override
            public void handle(PortableMessage event) {
                Object messageObject = ClientTopicProxy.this.getContext().getSerializationService().toObject(event.getMessage());
                MemberImpl member = ClientTopicProxy.this.getContext().getClusterService().getMember(event.getUuid());
                Message<Object> message = new Message<Object>(ClientTopicProxy.this.name, messageObject, event.getPublishTime(), member);
                listener.onMessage(message);
            }
        };
        return this.listen(request, this.getKey(), handler);
    }

    @Override
    public boolean removeMessageListener(String registrationId) {
        return this.stopListening(registrationId);
    }

    @Override
    public LocalTopicStats getLocalTopicStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!!!");
    }

    @Override
    protected void onDestroy() {
        TopicDestroyRequest request = new TopicDestroyRequest(this.name);
        this.invoke(request);
    }

    @Override
    public String getName() {
        return this.name;
    }

    private Data getKey() {
        if (this.key == null) {
            this.key = this.getContext().getSerializationService().toData(this.name);
        }
        return this.key;
    }

    private <T> T invoke(Object req) {
        try {
            return this.getContext().getInvocationService().invokeOnKeyOwner(req, this.getKey());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

