/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.connection.Connection;
import com.hazelcast.client.spi.impl.ClientClusterServiceImpl;
import com.hazelcast.client.txn.CommitTransactionRequest;
import com.hazelcast.client.txn.CreateTransactionRequest;
import com.hazelcast.client.txn.RollbackTransactionRequest;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionNotActiveException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.impl.Transaction;
import com.hazelcast.util.Clock;
import com.hazelcast.util.ExceptionUtil;
import java.io.IOException;

final class TransactionProxy {
    private static final ThreadLocal<Boolean> threadFlag = new ThreadLocal();
    private final TransactionOptions options;
    private final ClientClusterServiceImpl clusterService;
    private final long threadId = Thread.currentThread().getId();
    private final Connection connection;
    private String txnId;
    private Transaction.State state = Transaction.State.NO_TXN;
    private long startTime = 0L;

    TransactionProxy(HazelcastClient client, TransactionOptions options, Connection connection) {
        this.options = options;
        this.clusterService = (ClientClusterServiceImpl)client.getClientClusterService();
        this.connection = connection;
    }

    public String getTxnId() {
        return this.txnId;
    }

    public Transaction.State getState() {
        return this.state;
    }

    public long getTimeoutMillis() {
        return this.options.getTimeoutMillis();
    }

    void begin() {
        try {
            if (this.state == Transaction.State.ACTIVE) {
                throw new IllegalStateException("Transaction is already active");
            }
            this.checkThread();
            if (threadFlag.get() != null) {
                throw new IllegalStateException("Nested transactions are not allowed!");
            }
            threadFlag.set(Boolean.TRUE);
            this.startTime = Clock.currentTimeMillis();
            this.txnId = (String)this.sendAndReceive(new CreateTransactionRequest(this.options));
            this.state = Transaction.State.ACTIVE;
        }
        catch (Exception e) {
            this.closeConnection();
            throw ExceptionUtil.rethrow(e);
        }
    }

    void commit() {
        try {
            if (this.state != Transaction.State.ACTIVE) {
                throw new TransactionNotActiveException("Transaction is not active");
            }
            this.checkThread();
            this.checkTimeout();
            this.sendAndReceive(new CommitTransactionRequest());
            this.state = Transaction.State.COMMITTED;
        }
        catch (Exception e) {
            this.state = Transaction.State.ROLLING_BACK;
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rollback() {
        try {
            if (this.state == Transaction.State.NO_TXN || this.state == Transaction.State.ROLLED_BACK) {
                throw new IllegalStateException("Transaction is not active");
            }
            if (this.state == Transaction.State.ROLLING_BACK) {
                this.state = Transaction.State.ROLLED_BACK;
                return;
            }
            this.checkThread();
            try {
                this.sendAndReceive(new RollbackTransactionRequest());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.state = Transaction.State.ROLLED_BACK;
        }
        finally {
            this.closeConnection();
        }
    }

    private void closeConnection() {
        threadFlag.set(null);
        IOUtil.closeResource(this.connection);
    }

    private void checkThread() {
        if (this.threadId != Thread.currentThread().getId()) {
            throw new IllegalStateException("Transaction cannot span multiple threads!");
        }
    }

    private void checkTimeout() {
        if (this.startTime + this.options.getTimeoutMillis() < Clock.currentTimeMillis()) {
            throw new TransactionException("Transaction is timed-out!");
        }
    }

    private <T> T sendAndReceive(Object request) {
        try {
            return this.clusterService.sendAndReceiveFixedConnection(this.connection, request);
        }
        catch (IOException e) {
            throw ExceptionUtil.rethrow(e);
        }
    }
}

