/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.proxy;

import com.hazelcast.client.txn.TransactionContextProxy;
import com.hazelcast.client.txn.proxy.ClientTxnProxy;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.client.TxnMultiMapGetRequest;
import com.hazelcast.collection.operations.client.TxnMultiMapPutRequest;
import com.hazelcast.collection.operations.client.TxnMultiMapRemoveRequest;
import com.hazelcast.collection.operations.client.TxnMultiMapSizeRequest;
import com.hazelcast.collection.operations.client.TxnMultiMapValueCountRequest;
import com.hazelcast.core.TransactionalMultiMap;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.PortableCollection;
import com.hazelcast.transaction.TransactionException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ClientTxnMultiMapProxy<K, V>
extends ClientTxnProxy
implements TransactionalMultiMap<K, V> {
    public ClientTxnMultiMapProxy(CollectionProxyId id, TransactionContextProxy proxy) {
        super(id, proxy);
    }

    @Override
    public boolean put(K key, V value) throws TransactionException {
        TxnMultiMapPutRequest request = new TxnMultiMapPutRequest(this.getName(), this.toData(key), this.toData(value));
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public Collection<V> get(K key) {
        TxnMultiMapGetRequest request = new TxnMultiMapGetRequest(this.getName(), this.toData(key));
        PortableCollection portableCollection = (PortableCollection)this.invoke(request);
        Collection<Data> collection = portableCollection.getCollection();
        AbstractCollection coll = collection instanceof List ? new ArrayList(collection.size()) : new HashSet(collection.size());
        for (Data data : collection) {
            coll.add(this.toObject(data));
        }
        return coll;
    }

    @Override
    public boolean remove(Object key, Object value) {
        TxnMultiMapRemoveRequest request = new TxnMultiMapRemoveRequest(this.getName(), this.toData(key), this.toData(value));
        Boolean result = (Boolean)this.invoke(request);
        return result;
    }

    @Override
    public Collection<V> remove(Object key) {
        TxnMultiMapRemoveRequest request = new TxnMultiMapRemoveRequest(this.getName(), this.toData(key));
        PortableCollection portableCollection = (PortableCollection)this.invoke(request);
        Collection<Data> collection = portableCollection.getCollection();
        AbstractCollection coll = collection instanceof List ? new ArrayList(collection.size()) : new HashSet(collection.size());
        for (Data data : collection) {
            coll.add(this.toObject(data));
        }
        return coll;
    }

    @Override
    public int valueCount(K key) {
        TxnMultiMapValueCountRequest request = new TxnMultiMapValueCountRequest(this.getName(), this.toData(key));
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public int size() {
        TxnMultiMapSizeRequest request = new TxnMultiMapSizeRequest(this.getName());
        Integer result = (Integer)this.invoke(request);
        return result;
    }

    @Override
    public String getName() {
        CollectionProxyId proxyId = (CollectionProxyId)this.getId();
        return proxyId.getName();
    }

    @Override
    void onDestroy() {
    }
}

