/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jmx;

import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.jmx.HazelcastMBean;
import com.hazelcast.jmx.ManagedAnnotation;
import com.hazelcast.jmx.ManagedDescription;
import com.hazelcast.jmx.ManagementService;
import java.util.concurrent.atomic.AtomicLong;

@ManagedDescription(value="ITopic")
public class TopicMBean
extends HazelcastMBean<ITopic> {
    private AtomicLong totalMessageCount = new AtomicLong();
    private final String registrationId;

    protected TopicMBean(ITopic managedObject, ManagementService service) {
        super(managedObject, service);
        this.objectName = this.createObjectName("Topic", managedObject.getName());
        MessageListener messageListener = new MessageListener(){

            public void onMessage(Message message) {
                TopicMBean.this.totalMessageCount.incrementAndGet();
            }
        };
        this.registrationId = managedObject.addMessageListener(messageListener);
    }

    @ManagedAnnotation(value="name")
    @ManagedDescription(value="Name of the DistributedObject")
    public String getName() {
        return ((ITopic)this.managedObject).getName();
    }

    @ManagedAnnotation(value="totalMessageCount")
    public long getTotalMessageCount() {
        return this.totalMessageCount.get();
    }

    @ManagedAnnotation(value="config")
    public String getConfig() {
        return this.service.instance.getConfig().getTopicConfig(((ITopic)this.managedObject).getName()).toString();
    }

    @Override
    public void preDeregister() throws Exception {
        super.preDeregister();
        ((ITopic)this.managedObject).removeMessageListener(this.registrationId);
    }
}

